/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import java.util.List;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.AllListener;
import org.drools.verifier.core.index.select.FirstListener;
import org.drools.verifier.core.index.select.LastListener;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListenAddToEmptyTest {
    private Listen<Person> listen;
    private MultiMap<Value, Person, List<Person>> map;
    private Collection<Person> all;
    private Person first;
    private Person last;

    @Before
    public void setUp() throws Exception {
        this.map = MultiMapFactory.make((boolean)true);
        this.listen = new Listen(this.map, (Matcher)new ExactMatcher(KeyDefinition.newKeyDefinition().withId("ID").build(), (Comparable)((Object)"notInTheList"), true));
        this.listen.all((AllListener)new AllListener<Person>(){

            public void onAllChanged(Collection<Person> all) {
                ListenAddToEmptyTest.this.all = all;
            }
        });
        this.listen.first((FirstListener)new FirstListener<Person>(){

            public void onFirstChanged(Person first) {
                ListenAddToEmptyTest.this.first = first;
            }
        });
        this.listen.last((LastListener)new LastListener<Person>(){

            public void onLastChanged(Person last) {
                ListenAddToEmptyTest.this.last = last;
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertNull(this.all);
        Assert.assertNull((Object)this.first);
        Assert.assertNull((Object)this.last);
    }

    @Test
    public void testBeginning() throws Exception {
        Person baby = new Person(0, "baby");
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)baby);
        Assert.assertEquals((Object)baby, (Object)this.first);
        Assert.assertEquals((Object)baby, (Object)this.last);
        Assert.assertEquals((long)1L, (long)this.all.size());
    }

    class Person {
        int age;
        String name;

        public Person(int age, String name) {
            this.age = age;
            this.name = name;
        }
    }
}

