/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.Arrays;
import org.drools.verifier.core.checks.ComparableWrapper;
import org.junit.Assert;
import org.junit.Test;

public class ComparableWrapperTest {
    private final ComparableWrapper theNull = new ComparableWrapper(null);
    private final ComparableWrapper one = new ComparableWrapper((Comparable)Integer.valueOf(1));
    private final ComparableWrapper ten = new ComparableWrapper((Comparable)Integer.valueOf(10));
    private final ComparableWrapper min = ComparableWrapper.MIN_VALUE;
    private final ComparableWrapper max = ComparableWrapper.MAX_VALUE;

    @Test
    public void testSorting() {
        Object[] unsorted = new ComparableWrapper[]{this.one, this.ten, this.theNull, this.max, this.min};
        Object[] sorted = new ComparableWrapper[]{this.min, this.theNull, this.one, this.ten, this.max};
        Arrays.sort(unsorted);
        Assert.assertArrayEquals((Object[])sorted, (Object[])unsorted);
    }

    @Test
    public void compareTo() {
        Assert.assertEquals((long)0L, (long)this.theNull.compareTo(this.theNull));
        Assert.assertEquals((long)0L, (long)this.one.compareTo(this.one));
        Assert.assertEquals((long)0L, (long)this.ten.compareTo(this.ten));
        Assert.assertEquals((long)0L, (long)this.min.compareTo(this.min));
        Assert.assertEquals((long)0L, (long)this.max.compareTo(this.max));
        Assert.assertTrue((this.one.compareTo(this.theNull) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.ten) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.min) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.one.compareTo(this.max) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.ten.compareTo(this.theNull) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.ten.compareTo(this.one) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.ten.compareTo(this.min) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.ten.compareTo(this.max) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.min.compareTo(this.theNull) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.min.compareTo(this.one) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.min.compareTo(this.ten) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.min.compareTo(this.max) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.max.compareTo(this.theNull) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.max.compareTo(this.one) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.max.compareTo(this.ten) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.max.compareTo(this.min) > 0 ? 1 : 0) != 0);
    }
}

