/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import java.util.ArrayList;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.FieldInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Actions;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Conditions;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldAction;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FieldInspectorUpdateTest {
    @Mock
    ObjectField objectField;
    @Mock
    RuleInspectorUpdater ruleInspectorUpdater;
    private FieldCondition fieldCondition;
    private FieldAction fieldAction;
    private AnalyzerConfigurationMock configurationMock;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        Field field = (Field)Mockito.spy((Object)new Field(this.objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock));
        this.fieldCondition = this.makeCondition(field);
        this.fieldAction = this.makeAction(field);
        new FieldInspector(field, this.ruleInspectorUpdater, (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }

    private FieldCondition makeCondition(Field field) {
        FieldCondition fieldAction = new FieldCondition(field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(11)}), (AnalyzerConfiguration)this.configurationMock);
        ArrayList<FieldCondition> actionsList = new ArrayList<FieldCondition>();
        actionsList.add(fieldAction);
        Conditions conditions = new Conditions(actionsList);
        Mockito.when((Object)field.getConditions()).thenReturn((Object)conditions);
        return fieldAction;
    }

    private FieldAction makeAction(Field field) {
        FieldAction fieldAction = new FieldAction(field, (Column)Mockito.mock(Column.class), DataType.DataTypes.NUMERIC, new Values(new Comparable[]{Integer.valueOf(11)}), (AnalyzerConfiguration)this.configurationMock);
        ArrayList<FieldAction> actionsList = new ArrayList<FieldAction>();
        actionsList.add(fieldAction);
        Actions actions = new Actions(actionsList);
        Mockito.when((Object)field.getActions()).thenReturn((Object)actions);
        return fieldAction;
    }

    @Test
    public void updateAction() throws Exception {
        this.fieldAction.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetActionsInspectors();
    }

    @Test
    public void updateCondition() throws Exception {
        this.fieldCondition.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetConditionsInspectors();
    }
}

