/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.Util;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.maps.ChangeHandledMultiMap;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class KeyTreeMapTest {
    private final KeyDefinition AGE = KeyDefinition.newKeyDefinition().updatable().withId("age").build();
    private final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private KeyTreeMap<Person> map;
    private Person toni;
    private Person eder;
    private Person michael;
    private AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.map = new KeyTreeMap(new KeyDefinition[]{this.AGE, this.NAME});
        this.toni = new Person("Toni", 20);
        this.eder = new Person("Eder", 20);
        this.michael = new Person("Michael", 30);
        this.put(this.toni);
        this.put(this.eder);
        this.put(this.michael);
    }

    @Test
    public void testFindByUUID() throws Exception {
        Util.assertMapContent(this.map.get(UUIDKey.UNIQUE_UUID), new Comparable[]{this.toni.uuidKey, this.eder.uuidKey, this.michael.uuidKey});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReAdd() throws Exception {
        this.put(this.toni);
    }

    @Test
    public void testFindByName() throws Exception {
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("name").build()), new Comparable[]{"Toni", "Eder", "Michael"});
    }

    @Test
    public void testFindByAge() throws Exception {
        MultiMap age = this.map.get(KeyDefinition.newKeyDefinition().withId("age").build());
        Util.assertMapContent(age, Integer.valueOf(20), Integer.valueOf(20), Integer.valueOf(30));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.toni));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.eder));
    }

    @Test
    public void testUpdateAge() throws Exception {
        MultiMapChangeHandler changeHandler = (MultiMapChangeHandler)Mockito.mock(MultiMapChangeHandler.class);
        ((ChangeHandledMultiMap)this.map.get(this.AGE)).addChangeListener(changeHandler);
        this.toni.setAge(10);
        MultiMap age = this.map.get(this.AGE);
        Assert.assertFalse((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(20))).contains(this.toni));
        Assert.assertTrue((boolean)age.get((Comparable)new Value((Comparable)Integer.valueOf(10))).contains(this.toni));
    }

    @Test
    public void testRetract() throws Exception {
        this.toni.uuidKey.retract();
        Util.assertMapContent(this.map.get(UUIDKey.UNIQUE_UUID), new Comparable[]{this.eder.uuidKey, this.michael.uuidKey});
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("name").build()), new Comparable[]{"Eder", "Michael"});
        Util.assertMapContent(this.map.get(KeyDefinition.newKeyDefinition().withId("age").build()), Integer.valueOf(20), Integer.valueOf(30));
    }

    @Test
    public void testRemoveWhenItemDoesNotExist() throws Exception {
        UUIDKey uuidKey = (UUIDKey)Mockito.mock(UUIDKey.class);
        Mockito.when((Object)uuidKey.getKeyDefinition()).thenReturn((Object)UUIDKey.UNIQUE_UUID);
        Mockito.when((Object)uuidKey.getSingleValue()).thenReturn((Object)new Value((Comparable)((Object)"DoesNotExist")));
        Assert.assertNull((Object)this.map.remove(uuidKey));
        Assert.assertEquals((long)3L, (long)this.map.get(UUIDKey.UNIQUE_UUID).size());
    }

    private void put(Person person) {
        this.map.put((HasKeys)person);
    }

    class Person
    implements HasKeys {
        final String name;
        private final UUIDKey uuidKey;
        private UpdatableKey ageKey;

        public Person(String name, int age) {
            this.uuidKey = KeyTreeMapTest.this.configuration.getUUID((HasKeys)this);
            this.name = name;
            this.ageKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyTreeMapTest.this.NAME, (Comparable)((Object)this.name)), this.ageKey};
        }

        public void setAge(int age) {
            UpdatableKey newKey;
            UpdatableKey oldKey = this.ageKey;
            this.ageKey = newKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

