/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.FieldInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FieldInspectorRelationsTest {
    private AnalyzerConfigurationMock configurationMock;
    private FieldInspector a;
    private FieldInspector b;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        ObjectField objectField = (ObjectField)Mockito.mock(ObjectField.class);
        this.a = new FieldInspector(new Field(objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        this.b = new FieldInspector(new Field(objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    @Test
    public void testRedundancy01() throws Exception {
        Assertions.assertThat((boolean)this.a.isRedundant((Object)this.b)).isTrue();
        Assertions.assertThat((boolean)this.b.isRedundant((Object)this.a)).isTrue();
    }

    @Test
    public void testRedundancy02() throws Exception {
        FieldInspector x = new FieldInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.Address", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assertions.assertThat((boolean)x.isRedundant((Object)this.b)).isFalse();
        Assertions.assertThat((boolean)this.b.isRedundant((Object)x)).isFalse();
    }

    @Test
    public void testSubsumpt01() throws Exception {
        Assertions.assertThat((boolean)this.a.subsumes((Object)this.b)).isTrue();
        Assertions.assertThat((boolean)this.b.subsumes((Object)this.a)).isTrue();
    }

    @Test
    public void testSubsumpt02() throws Exception {
        FieldInspector x = new FieldInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.Address", "String", "name", (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assertions.assertThat((boolean)x.subsumes((Object)this.b)).isFalse();
        Assertions.assertThat((boolean)this.b.subsumes((Object)x)).isFalse();
    }
}

