/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.model.ActivationTime;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActivationTimeTest {
    private final ActivationTime start;
    private final ActivationTime end;
    private final boolean expected;

    public ActivationTimeTest(ActivationTime start, ActivationTime end, boolean expected) {
        this.start = start;
        this.end = end;
        this.expected = expected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({new ActivationTime(new Date(0L), new Date(10L)), new ActivationTime(new Date(0L), new Date(10L)), true}, {new ActivationTime(new Date(0L), new Date(10L)), new ActivationTime(new Date(10L), new Date(100L)), true}, {new ActivationTime(new Date(10L), new Date(20L)), new ActivationTime(new Date(0L), new Date(100L)), true}, {new ActivationTime(new Date(0L), new Date(100L)), new ActivationTime(new Date(10L), new Date(20L)), true}, {new ActivationTime(new Date(0L), new Date(100L)), new ActivationTime(new Date(0L), new Date(20L)), true}, {new ActivationTime(new Date(0L), new Date(100L)), new ActivationTime(new Date(0L), new Date(20L)), true}, {new ActivationTime(new Date(0L), new Date(100L)), new ActivationTime(new Date(10L), new Date(100L)), true}, {new ActivationTime(new Date(10L), new Date(100L)), new ActivationTime(new Date(0L), new Date(100L)), true}, {new ActivationTime(new Date(10L), new Date(100L)), new ActivationTime(new Date(0L), new Date(10L)), true}, {new ActivationTime(new Date(0L), new Date(10L)), new ActivationTime(new Date(100L), new Date(110L)), false}, {new ActivationTime(new Date(100L), new Date(110L)), new ActivationTime(new Date(0L), new Date(10L)), false}, {new ActivationTime(null, new Date(100L)), new ActivationTime(new Date(10L), null), true}, {new ActivationTime(null, new Date(10L)), new ActivationTime(new Date(100L), null), false}, {new ActivationTime(new Date(10L), null), new ActivationTime(null, new Date(100L)), true}, {new ActivationTime(new Date(100L), null), new ActivationTime(null, new Date(10L)), false}, {new ActivationTime(null, null), new ActivationTime(null, null), true}, {new ActivationTime(null, null), new ActivationTime(new Date(100L), new Date(110L)), true}, {new ActivationTime(new Date(100L), new Date(110L)), new ActivationTime(null, null), true}, {new ActivationTime(null, null), new ActivationTime(null, new Date(110L)), true}, {new ActivationTime(null, new Date(110L)), new ActivationTime(null, null), true}, {new ActivationTime(null, null), new ActivationTime(new Date(100L), null), true}, {new ActivationTime(new Date(100L), null), new ActivationTime(null, null), true});
    }

    @Test
    public void testOverlaps() {
        Assertions.assertThat((boolean)this.start.overlaps(this.end)).isEqualTo(this.expected);
    }
}

