/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SelectExactMatcherNegateTest {
    private int amount;
    private Select<Item> select;
    private Object firstValue;
    private Object lastValue;

    private MultiMap<Value, Item, List<Item>> makeMap() {
        MultiMap itemKeyTreeMap = MultiMapFactory.make();
        itemKeyTreeMap.put((Comparable)new Value(null), (Object)new Item(null));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)new Item(0));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(56)), (Object)new Item(56));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)new Item(100));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(1200)), (Object)new Item(1200));
        return itemKeyTreeMap;
    }

    public SelectExactMatcherNegateTest(int amount, Object firstValue, Object lastValue, Matcher matcher) throws Exception {
        this.firstValue = firstValue;
        this.lastValue = lastValue;
        this.amount = amount;
        this.select = new Select(this.makeMap(), matcher);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({5, null, 1200, new ExactMatcher(KeyDefinition.newKeyDefinition().withId("cost").build(), (Comparable)Integer.valueOf(13), true)}, {4, 0, 1200, new ExactMatcher(KeyDefinition.newKeyDefinition().withId("cost").build(), null, true)});
    }

    @Test
    public void testAll() throws Exception {
        Collection all = this.select.all();
        Assertions.assertThat((int)all.size()).isEqualTo(this.amount);
    }

    @Test
    public void testFirst() throws Exception {
        Assertions.assertThat((Integer)((Item)this.select.first()).cost).isEqualTo(this.firstValue);
    }

    @Test
    public void testLast() throws Exception {
        Assertions.assertThat((Integer)((Item)this.select.last()).cost).isEqualTo(this.lastValue);
    }

    private class Item {
        private Integer cost;

        public Item(Integer cost) {
            this.cost = cost;
        }
    }
}

