/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringConditionInspectorOverlapTest {
    @Mock
    private Field field;

    @Test
    public void test001() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    public void test002() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test003() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test004() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test005() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    public void test006() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test007() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder", "John"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    public void test008() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni", "Eder"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test009() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "in");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Eder", "Toni"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    public void test010() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{""}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{""}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    public void test011() throws Exception {
        StringConditionInspector a = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = this.getCondition(new Values(new Comparable[]{"Toni"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    private StringConditionInspector getCondition(Values values, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values, (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

