/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.Comparator;
import java.util.Objects;

public class ComparableWrapper
implements Comparable<ComparableWrapper> {
    public static final ComparableWrapper MIN_VALUE = new ComparableWrapper(null, Type.NEGATIVE_INFINITE);
    public static final ComparableWrapper MAX_VALUE = new ComparableWrapper(null, Type.INFINITE);
    private final Comparable value;
    private final Type type;

    public ComparableWrapper(Comparable value) {
        this(value, Type.NORMAL);
    }

    private ComparableWrapper(Comparable value, Type type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public int compareTo(ComparableWrapper other) {
        if (!Objects.equals((Object)this.type, (Object)Type.NORMAL) || !Objects.equals((Object)other.type, (Object)Type.NORMAL)) {
            return this.type.compareTo(other.type);
        }
        Comparator<Comparable> nullFirstCompare = Comparator.nullsFirst(Comparable::compareTo);
        return nullFirstCompare.compare(this.value, other.value);
    }

    public Comparable getValue() {
        return this.value;
    }

    static enum Type {
        NEGATIVE_INFINITE,
        NORMAL,
        INFINITE;

    }
}

