/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.Before;
import org.junit.Test;

public class KeyTreeMapMergeTest {
    private static final KeyDefinition NAME_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("name").build();
    private static final KeyDefinition AGE_KEY_DEFINITION = KeyDefinition.newKeyDefinition().withId("age").build();
    private KeyTreeMap<Person> treeMap;
    private Person pat;
    private KeyTreeMap<Person> otherKeyTreeMap;
    private Person mat;
    private Matcher nameMatcher = new Matcher(NAME_KEY_DEFINITION);
    private AnalyzerConfigurationMock configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.treeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        this.pat = new Person("Pat", 10);
        this.add(this.treeMap, this.pat);
        this.otherKeyTreeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        this.mat = new Person("mat", 15);
        this.add(this.otherKeyTreeMap, this.mat);
    }

    private void add(KeyTreeMap<Person> treeMap, Person person) {
        treeMap.put((HasKeys)person);
    }

    @Test
    public void testMergeToEmptyMap() throws Exception {
        KeyTreeMap empty = new KeyTreeMap(new KeyDefinition[]{UUIDKey.UNIQUE_UUID, NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        empty.merge(this.otherKeyTreeMap);
        Assertions.assertThat((int)empty.get(this.nameMatcher.getKeyDefinition()).allValues().size()).isEqualTo(1);
    }

    @Test
    public void testNames() throws Exception {
        this.treeMap.merge(this.otherKeyTreeMap);
        MultiMap multiMap = this.treeMap.get(this.nameMatcher.getKeyDefinition());
        Assertions.assertThat((int)multiMap.allValues().size()).isEqualTo(2);
    }

    @Test
    public void testAge() throws Exception {
        this.treeMap.merge(this.otherKeyTreeMap);
        Assertions.assertThat((int)this.allPersons(this.treeMap).size()).isEqualTo(2);
    }

    @Test
    public void testRetract() throws Exception {
        KeyTreeMap thirdKeyTreeMap = new KeyTreeMap(new KeyDefinition[]{NAME_KEY_DEFINITION, AGE_KEY_DEFINITION});
        thirdKeyTreeMap.merge(this.treeMap);
        thirdKeyTreeMap.merge(this.otherKeyTreeMap);
        Assertions.assertThat((int)this.allPersons((KeyTreeMap<Person>)thirdKeyTreeMap).size()).isEqualTo(2);
        Assertions.assertThat((int)this.allPersons(this.treeMap).size()).isEqualTo(1);
        Assertions.assertThat((int)this.allPersons(this.otherKeyTreeMap).size()).isEqualTo(1);
        this.pat.uuidKey.retract();
        Assertions.assertThat((int)this.allPersons((KeyTreeMap<Person>)thirdKeyTreeMap).size()).isEqualTo(1);
        Assertions.assertThat((int)this.allPersons(this.treeMap).size()).isEqualTo(0);
        Assertions.assertThat((int)this.allPersons(this.otherKeyTreeMap).size()).isEqualTo(1);
    }

    private Collection<Person> allPersons(KeyTreeMap<Person> personKeyTreeMap) {
        Matcher age = new Matcher(KeyDefinition.newKeyDefinition().withId("age").build());
        MultiMap personChangeHandledMultiMap = personKeyTreeMap.get(age.getKeyDefinition());
        if (personChangeHandledMultiMap != null) {
            return personChangeHandledMultiMap.allValues();
        }
        return Collections.emptyList();
    }

    private class Person
    implements HasKeys {
        private String name;
        private Integer age;
        private UUIDKey uuidKey;

        public Person(String name, Integer age) {
            this.uuidKey = KeyTreeMapMergeTest.this.configuration.getUUID(this);
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public Integer getAge() {
            return this.age;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(NAME_KEY_DEFINITION, (Comparable)((Object)this.name)), new Key(AGE_KEY_DEFINITION, (Comparable)this.age)};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

