/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.action;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.verifier.core.cache.inspectors.action.FieldActionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldAction;
import org.drools.verifier.core.index.model.ObjectField;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionInspectorConflictResolverTest {
    private AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
    }

    @Test
    public void testRedundancy001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isTrue();
    }

    @Test
    public void testRedundancy002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Rambo"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isFalse();
    }

    @Test
    public void testRedundancy003() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test1.Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "org.test2.Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isFalse();
    }

    @Test
    public void testRedundancy004() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"true"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isTrue();
    }

    @Test
    public void testRedundancy005() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"false"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isFalse();
    }

    @Test
    public void testRedundancy006() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"20"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isTrue();
    }

    @Test
    public void testRedundancy007() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), Integer.valueOf(20));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "age", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"10"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isFalse();
    }

    @Test
    public void testRedundancy008() throws Exception {
        Date date = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), date);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)this.format(date)));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isTrue();
    }

    @Test
    public void testRedundancy009() throws Exception {
        Date value = new Date();
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), value);
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "birthDay", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"29-Dec-1981"));
        Assertions.assertThat((boolean)a.isRedundant((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.isRedundant((Object)a)).isFalse();
    }

    @Test
    public void testConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Rambo"));
        Assertions.assertThat((boolean)a.conflicts((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.conflicts((Object)a)).isTrue();
    }

    @Test
    public void testConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), Boolean.valueOf(true));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Boolean", "isOldEnough", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"false"));
        Assertions.assertThat((boolean)a.conflicts((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.conflicts((Object)a)).isTrue();
    }

    @Test
    public void testNoConflict001() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Address", "String", "street", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Rambo"));
        Assertions.assertThat((boolean)a.conflicts((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.conflicts((Object)a)).isFalse();
    }

    @Test
    public void testNoConflict002() throws Exception {
        ActionInspector a = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        ActionInspector b = this.createSetActionInspector(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Comparable)((Object)"Toni"));
        Assertions.assertThat((boolean)a.conflicts((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.conflicts((Object)a)).isFalse();
    }

    @Test
    public void testNoConflict003() throws Exception {
        ActionInspector a = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Column)Mockito.mock(Column.class), new Values(new Comparable[]{Boolean.valueOf(true)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()));
        ActionInspector b = this.createSetActionInspector((Action)new FieldAction(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (Column)Mockito.mock(Column.class), new Values(new Comparable[]{Boolean.valueOf(true)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()));
        Assertions.assertThat((boolean)a.conflicts((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.conflicts((Object)a)).isFalse();
    }

    private ActionInspector createSetActionInspector(Field field, Comparable comparable) {
        return new FieldActionInspector(new FieldAction(field, (Column)Mockito.mock(Column.class), new Values(new Comparable[]{comparable}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()), this.configuration);
    }

    private ActionInspector createSetActionInspector(Action action) {
        return new ActionInspector(action, new AnalyzerConfigurationMock()){};
    }

    private String format(Date dateValue) {
        return this.configuration.formatDate(dateValue);
    }
}

