/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class BooleanConditionInspectorTest {
    private final boolean value1;
    private final boolean value2;
    private final String operator1;
    private final String operator2;
    private final boolean conflictExpected;
    private final Field field = (Field)Mockito.mock(Field.class);

    public BooleanConditionInspectorTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.conflictExpected = conflictExpected;
    }

    @Test
    public void parametrizedConflictTest() {
        BooleanConditionInspector a = this.getCondition(this.value1, this.operator1);
        BooleanConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription(a, b, this.conflictExpected, "conflict"), new Object[0])).isEqualTo(this.conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription(b, a, this.conflictExpected, "conflict"), new Object[0])).isEqualTo(this.conflictExpected);
    }

    @Test
    public void parametrizedRedundancyTest() {
        BooleanConditionInspector a = this.getCondition(this.value1, this.operator1);
        BooleanConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(this.getAssertDescription(a, b, !this.conflictExpected, "be redundant"), new Object[0])).isEqualTo(!this.conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(this.getAssertDescription(b, a, !this.conflictExpected, "be redundant"), new Object[0])).isEqualTo(!this.conflictExpected);
    }

    @Test
    public void parametrizedOverlapTest() {
        BooleanConditionInspector a = this.getCondition(this.value1, this.operator1);
        BooleanConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription(a, b, !this.conflictExpected, "overlap"), new Object[0])).isEqualTo(!this.conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription(b, a, !this.conflictExpected, "overlap"), new Object[0])).isEqualTo(!this.conflictExpected);
    }

    @Test
    public void parametrizedSubsumptionTest() {
        BooleanConditionInspector a = this.getCondition(this.value1, this.operator1);
        BooleanConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.subsumes((Object)b)).as(this.getAssertDescription(a, b, !this.conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!this.conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.subsumes((Object)a)).as(this.getAssertDescription(b, a, !this.conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!this.conflictExpected);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"!=", true, "!=", true, false}, {"==", true, "==", true, false}, {"!=", true, "==", false, false}, {"!=", true, "!=", false, true}, {"==", true, "==", false, true}, {"!=", true, "==", true, true});
    }

    private String getAssertDescription(BooleanConditionInspector a, BooleanConditionInspector b, boolean conditionExpected, String condition) {
        return String.format("Expected conditions '%s' and '%s' %sto %s:", a.toHumanReadableString(), b.toHumanReadableString(), conditionExpected ? "" : "not ", condition);
    }

    private BooleanConditionInspector getCondition(boolean value, String operator) {
        return new BooleanConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Boolean.valueOf(value)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }
}

