/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.relations.IsConflicting;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConditionsInspectorTest {
    Field field;
    private AnalyzerConfigurationMock configurationMock;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        this.field = new Field(new ObjectField("Person", "Integer", "age", (AnalyzerConfiguration)this.configurationMock), "Person", "Integer", "age", (AnalyzerConfiguration)this.configurationMock);
    }

    @Test
    public void testSubsume001() throws Exception {
        ConditionsInspectorMultiMap a = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(1)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        ConditionsInspectorMultiMap b = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(1)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        Assertions.assertThat((boolean)a.subsumes((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.subsumes((Object)a)).isTrue();
    }

    @Test
    public void testSubsume002() throws Exception {
        ConditionsInspectorMultiMap a = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(1)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        ConditionsInspectorMultiMap b = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(1)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), new ComparableConditionInspector(new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "Integer", "balance", (AnalyzerConfiguration)this.configurationMock), (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(111111111)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        Assertions.assertThat((boolean)a.subsumes((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.subsumes((Object)a)).isTrue();
    }

    @Test
    public void testSubsume003() throws Exception {
        Field nameField = new Field(new ObjectField("Person", "String", "name", (AnalyzerConfiguration)this.configurationMock), "Person", "String", "name", (AnalyzerConfiguration)this.configurationMock);
        Field lastNameField = new Field(new ObjectField("Person", "String", "lastName", (AnalyzerConfiguration)this.configurationMock), "Person", "String", "lastName", (AnalyzerConfiguration)this.configurationMock);
        ConditionsInspectorMultiMap a = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(nameField, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{"Toni"}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        ConditionsInspectorMultiMap b = this.getConditions(new ConditionInspector[]{new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(12)}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), new ComparableConditionInspector(new FieldCondition(nameField, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{"Toni"}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), new ComparableConditionInspector(new FieldCondition(lastNameField, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{"Rikkola"}), (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock)});
        Assertions.assertThat((boolean)a.subsumes((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.subsumes((Object)a)).isTrue();
    }

    private ConditionsInspectorMultiMap getConditions(ConditionInspector ... numericIntegerConditions) {
        ConditionsInspectorMultiMap conditionsInspector = new ConditionsInspectorMultiMap((AnalyzerConfiguration)this.configurationMock);
        for (ConditionInspector inspector : numericIntegerConditions) {
            conditionsInspector.put((Comparable)((ComparableConditionInspector)inspector).getField().getObjectField(), (IsConflicting)inspector);
        }
        return conditionsInspector;
    }
}

