/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.PatternInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.index.model.Pattern;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PatternInspectorTest {
    private AnalyzerConfigurationMock configurationMock;
    private PatternInspector a;
    private PatternInspector b;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        this.a = new PatternInspector(new Pattern("a", new ObjectType("org.Person", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        this.b = new PatternInspector(new Pattern("b", new ObjectType("org.Person", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    @Test
    public void testRedundancy01() throws Exception {
        Assertions.assertThat((boolean)this.a.isRedundant((Object)this.b)).isTrue();
        Assertions.assertThat((boolean)this.b.isRedundant((Object)this.a)).isTrue();
    }

    @Test
    public void testRedundancy02() throws Exception {
        PatternInspector x = new PatternInspector(new Pattern("x", new ObjectType("org.Address", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assertions.assertThat((boolean)x.isRedundant((Object)this.b)).isFalse();
        Assertions.assertThat((boolean)this.b.isRedundant((Object)x)).isFalse();
    }

    @Test
    public void testSubsumpt01() throws Exception {
        Assertions.assertThat((boolean)this.a.subsumes((Object)this.b)).isTrue();
        Assertions.assertThat((boolean)this.b.subsumes((Object)this.a)).isTrue();
    }

    @Test
    public void testSubsumpt02() throws Exception {
        PatternInspector x = new PatternInspector(new Pattern("x", new ObjectType("org.Address", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assertions.assertThat((boolean)x.subsumes((Object)this.b)).isFalse();
        Assertions.assertThat((boolean)this.b.subsumes((Object)x)).isFalse();
    }
}

