/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DateConditionInspectorSubsumptionTest {
    @Mock
    private Field field;

    @Test
    public void testSubsume001() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(100L), "!=");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(100L), "!=");
        Assertions.assertThat((boolean)a.subsumes(b)).isTrue();
        Assertions.assertThat((boolean)b.subsumes(a)).isTrue();
    }

    @Test
    public void testSubsumeEquals001() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(100L), "==");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(10L), ">");
        Assertions.assertThat((boolean)a.subsumes(b)).isFalse();
        Assertions.assertThat((boolean)b.subsumes(a)).isTrue();
    }

    @Test
    public void testSubsumeEquals002() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(10L), "==");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(100L), ">");
        Assertions.assertThat((boolean)a.subsumes(b)).isFalse();
        Assertions.assertThat((boolean)b.subsumes(a)).isFalse();
    }

    private ComparableConditionInspector<Date> getCondition(Date date, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{date}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

