/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class NumericIntegerConditionInspectorConflictResolverOverlapTest {
    private final Integer value1;
    private final Integer value2;
    private final String operator1;
    private final String operator2;
    private final boolean overlapExpected;
    private final Field field = (Field)Mockito.mock(Field.class);

    public NumericIntegerConditionInspectorConflictResolverOverlapTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.overlapExpected = overlapExpected;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">", 10, false}, {"==", 0, ">=", 1, false}, {"==", 0, ">=", 10, false}, {"==", 0, "<", 0, false}, {"==", 0, "<", -10, false}, {"==", 0, "<=", -1, false}, {"==", 0, "<=", -10, false}, {"==", 0, "!=", 1, true}, {"==", 0, ">", -1, true}, {"==", 0, ">", -10, true}, {"==", 0, ">=", 0, true}, {"==", 0, ">=", -10, true}, {"==", 0, "<", 1, true}, {"==", 0, "<", 10, true}, {"==", 0, "<=", 0, true}, {"==", 0, "<=", 10, true}, {"!=", 0, "!=", 1, true}, {"!=", 0, ">", -1, true}, {"!=", 0, ">", -10, true}, {"!=", 0, ">=", 0, true}, {"!=", 0, ">=", -10, true}, {"!=", 0, "<", 1, true}, {"!=", 0, "<", 10, true}, {"!=", 0, "<=", 0, true}, {"!=", 0, "<=", 10, true}, {">", 0, "<", 1, true}, {">", 0, "<", -10, false}, {">", 0, "<=", 0, false}, {">", 0, "<=", -10, false}, {">", 0, ">", -1, true}, {">", 0, ">", -10, true}, {">", 0, ">=", 0, true}, {">", 0, ">=", 1, true}, {">", 0, ">=", -10, true}, {">", 0, "<", 2, true}, {">", 0, "<", 10, true}, {">", 0, "<=", 1, true}, {">", 0, "<=", 10, true}, {">=", 0, "<", 0, false}, {">=", 0, "<", -10, false}, {">=", 0, "<=", -1, false}, {">=", 0, "<=", -10, false}, {">=", 0, ">=", 1, true}, {">=", 0, ">=", -10, true}, {">=", 0, "<", 1, true}, {">=", 0, "<", 10, true}, {">=", 0, "<=", 0, true}, {">=", 0, "<=", 10, true}, {"<", 0, "<", 1, true}, {"<", 0, "<", 10, true}, {"<", 0, "<=", -1, true}, {"<", 0, "<=", 0, true}, {"<", 0, "<=", 10, true}, {"<=", 0, "<=", -1, true}, {"<=", 0, "<=", 10, true});
    }

    @Test
    public void parametrizedOverlapTest() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription(a, b, this.overlapExpected, "overlap"), new Object[0])).isEqualTo(this.overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription(b, a, this.overlapExpected, "overlap"), new Object[0])).isEqualTo(this.overlapExpected);
    }

    @Test
    public void parametrizedConflictTest() {
        NumericIntegerConditionInspector a = this.getCondition(this.value1, this.operator1);
        NumericIntegerConditionInspector b = this.getCondition(this.value2, this.operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription(a, b, !this.overlapExpected, "conflict"), new Object[0])).isEqualTo(!this.overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription(b, a, !this.overlapExpected, "conflict"), new Object[0])).isEqualTo(!this.overlapExpected);
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected, String condition) {
        return String.format("Expected condition '%s' %sto %s with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", condition, b.toHumanReadableString());
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

