/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.checks.ComparableWrapper;
import org.junit.Test;

public class ComparableWrapperTest {
    private final ComparableWrapper theNull = new ComparableWrapper(null);
    private final ComparableWrapper one = new ComparableWrapper((Comparable)Integer.valueOf(1));
    private final ComparableWrapper ten = new ComparableWrapper((Comparable)Integer.valueOf(10));
    private final ComparableWrapper min = ComparableWrapper.MIN_VALUE;
    private final ComparableWrapper max = ComparableWrapper.MAX_VALUE;

    @Test
    public void testSorting() {
        Object[] unsorted = new ComparableWrapper[]{this.one, this.ten, this.theNull, this.max, this.min};
        Object[] sorted = new ComparableWrapper[]{this.min, this.theNull, this.one, this.ten, this.max};
        Arrays.sort(unsorted);
        Assertions.assertThat((Object[])sorted).isEqualTo((Object)unsorted);
    }

    @Test
    public void compareTo() {
        Assertions.assertThat((int)this.theNull.compareTo(this.theNull)).isEqualTo(0);
        Assertions.assertThat((int)this.one.compareTo(this.one)).isEqualTo(0);
        Assertions.assertThat((int)this.ten.compareTo(this.ten)).isEqualTo(0);
        Assertions.assertThat((int)this.min.compareTo(this.min)).isEqualTo(0);
        Assertions.assertThat((int)this.max.compareTo(this.max)).isEqualTo(0);
        Assertions.assertThat((this.one.compareTo(this.theNull) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.one.compareTo(this.ten) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.one.compareTo(this.min) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.one.compareTo(this.max) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.ten.compareTo(this.theNull) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.ten.compareTo(this.one) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.ten.compareTo(this.min) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.ten.compareTo(this.max) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.min.compareTo(this.theNull) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.min.compareTo(this.one) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.min.compareTo(this.ten) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.min.compareTo(this.max) < 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.max.compareTo(this.theNull) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.max.compareTo(this.one) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.max.compareTo(this.ten) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.max.compareTo(this.min) > 0 ? 1 : 0) != 0).isTrue();
    }
}

