/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.Before;
import org.junit.Test;

public class SelectExactMatcherTest {
    private Select<Item> select;
    private MultiMap<Value, Item, List<Item>> map;
    private Item thirteen;

    @Before
    public void setUp() throws Exception {
        this.map = MultiMapFactory.make();
        this.thirteen = new Item(13);
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)new Item(0));
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(13)), (Object)this.thirteen);
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(56)), (Object)new Item(56));
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)new Item(100));
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(1200)), (Object)new Item(1200));
        this.select = new Select(this.map, (Matcher)new ExactMatcher(KeyDefinition.newKeyDefinition().withId("cost").build(), (Comparable)Integer.valueOf(13)));
    }

    @Test
    public void testAll() throws Exception {
        Collection all = this.select.all();
        Assertions.assertThat((int)all.size()).isEqualTo(1);
    }

    @Test
    public void testFirst() throws Exception {
        Assertions.assertThat((Object)((Item)this.select.first())).isEqualTo((Object)this.thirteen);
    }

    @Test
    public void testLast() throws Exception {
        Assertions.assertThat((Object)((Item)this.select.last())).isEqualTo((Object)this.thirteen);
    }

    private class Item {
        private Integer cost;

        public Item(Integer cost) {
            this.cost = cost;
        }
    }
}

