/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.Before;
import org.junit.Test;

public class KeyTreeMapUUIDKeyTest {
    AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoKey() throws Exception {
        KeyTreeMap map = new KeyTreeMap(new KeyDefinition[]{UUIDKey.UNIQUE_UUID});
        map.put((HasKeys)new NoKey());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTwoKeys() throws Exception {
        KeyTreeMap map = new KeyTreeMap(new KeyDefinition[]{UUIDKey.UNIQUE_UUID});
        map.put((HasKeys)new TwoKeys());
    }

    private class TwoKeys
    implements HasKeys {
        private TwoKeys() {
        }

        public Key[] keys() {
            return new Key[]{KeyTreeMapUUIDKeyTest.this.configuration.getUUID((HasKeys)this), KeyTreeMapUUIDKeyTest.this.configuration.getUUID((HasKeys)this)};
        }

        public UUIDKey getUuidKey() {
            return null;
        }
    }

    private class NoKey
    implements HasKeys {
        private NoKey() {
        }

        public Key[] keys() {
            return new Key[0];
        }

        public UUIDKey getUuidKey() {
            return null;
        }
    }
}

