/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorFactory;
import org.drools.verifier.core.maps.UpdatableInspectorList;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasUUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class UpdatableInspectorListTest {
    private UpdatableInspectorList<HasUUID, Item> list;
    private AnalyzerConfiguration configuration;

    @Before
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.list = new UpdatableInspectorList((InspectorFactory)new InspectorFactory<HasUUID, Item>(this.configuration){

            public HasUUID make(Item item) {
                return new HasUUID(){

                    public UUIDKey getUuidKey() {
                        return (UUIDKey)Mockito.mock(UUIDKey.class);
                    }
                };
            }
        }, this.configuration);
    }

    @Test
    public void add() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(1);
    }

    @Test
    public void reAdd() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(1);
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(1);
    }

    @Test
    public void reAddNew() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(1);
        updates.add(new Item());
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(2);
    }

    @Test
    public void remove() throws Exception {
        ArrayList<Item> updates = new ArrayList<Item>();
        updates.add(new Item());
        Item removeMe = new Item();
        updates.add(removeMe);
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(2);
        updates.remove(removeMe);
        this.list.update(updates);
        Assertions.assertThat((int)this.list.size()).isEqualTo(1);
    }

    private class Item
    implements HasKeys {
        private UUIDKey uuidKey;

        private Item() {
            this.uuidKey = UpdatableInspectorListTest.this.configuration.getUUID((HasKeys)this);
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

