/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.RuleInspectorCache;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.IndexImpl;
import org.drools.verifier.core.index.model.Rule;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class RuleInspectorCacheTest {
    private RuleInspectorCache cache;

    @BeforeEach
    public void setUp() throws Exception {
        IndexImpl index = new IndexImpl();
        AnalyzerConfigurationMock configuration = new AnalyzerConfigurationMock();
        this.cache = new RuleInspectorCache((Index)index, (AnalyzerConfiguration)configuration);
        this.cache.addRule(new Rule(Integer.valueOf(0), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(1), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(2), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(3), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(4), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(5), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(6), (AnalyzerConfiguration)configuration));
    }

    @Test
    void testInit() throws Exception {
        Assertions.assertThat((int)this.cache.all().size()).isEqualTo(7);
    }

    @Test
    void testRemoveRow() throws Exception {
        this.cache.removeRow(3);
        Collection all = this.cache.all();
        Assertions.assertThat((int)all.size()).isEqualTo(6);
        this.assertContainsRowNumbers(all, 0, 1, 2, 3, 4, 5);
    }

    private void assertContainsRowNumbers(Collection<RuleInspector> all, int ... numbers) {
        ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
        for (RuleInspector ruleInspector : all) {
            int rowIndex = ruleInspector.getRowIndex();
            rowNumbers.add(rowIndex);
        }
        for (Object number : (Object)numbers) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)rowNumbers.contains((int)number)).as(rowNumbers.toString(), new Object[0])).isTrue();
        }
    }
}

