/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class NumericIntegerConditionInspectorSubsumptionTest {
    private Integer value1;
    private Integer value2;
    private String operator1;
    private String operator2;
    private boolean aSubsumesB;
    private boolean bSubsumesA;
    private Field field;

    public void initNumericIntegerConditionInspectorSubsumptionTest(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.aSubsumesB = aSubsumesB;
        this.bSubsumesA = bSubsumesA;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true, true}, {"!=", 0, "!=", 0, true, true}, {">", 0, ">", 0, true, true}, {">=", 0, ">=", 0, true, true}, {"<", 0, "<", 0, true, true}, {"<=", 0, "<=", 0, true, true}, {"==", 0, "==", 1, false, false}, {"==", 0, "!=", 0, false, false}, {"==", 0, ">", 0, false, false}, {"==", 0, ">", 10, false, false}, {"==", 0, ">=", 1, false, false}, {"==", 0, ">=", 10, false, false}, {"==", 0, "<", 0, false, false}, {"==", 0, "<", -10, false, false}, {"==", 0, "<=", -1, false, false}, {"==", 0, "<=", -10, false, false}, {"==", 0, "!=", 1, true, false}, {"==", 0, ">", -1, false, true}, {"==", 0, ">", -10, false, true}, {"==", 0, ">=", 0, false, true}, {"==", 0, ">=", -10, false, true}, {"==", 0, "<", 1, false, true}, {"==", 0, "<", 10, false, true}, {"==", 0, "<=", 0, false, true}, {"==", 0, "<=", 10, false, true}, {"!=", 0, "!=", 1, false, false}, {"!=", 0, ">", -1, false, false}, {"!=", 0, ">", -10, false, false}, {"!=", 0, ">=", 0, false, false}, {"!=", 0, ">=", -10, false, false}, {"!=", 0, "<", 1, false, false}, {"!=", 0, "<", 10, false, false}, {"!=", 0, "<=", 0, false, false}, {"!=", 0, "<=", 10, false, false}, {"!=", 0, ">", 0, true, false}, {"!=", 0, ">", 10, true, false}, {"!=", 0, ">=", 1, true, false}, {"!=", 0, ">=", 10, true, false}, {"!=", 0, "<", 0, true, false}, {"!=", 0, "<", -10, true, false}, {"!=", 0, "<=", -1, true, false}, {"!=", 0, "<=", -10, true, false}, {">", 0, "<", 1, false, false}, {">", 0, "<", -10, false, false}, {">", 0, "<", 10, false, false}, {">", 0, "<=", 0, false, false}, {">", 0, "<=", -10, false, false}, {">", 0, "<=", 10, false, false}, {">", 0, ">", 1, true, false}, {">", 0, ">", 10, true, false}, {">", 0, ">=", 0, false, true}, {">", 0, ">=", 10, true, false}, {">=", 0, "<", 0, false, false}, {">=", 0, "<", -10, false, false}, {">=", 0, "<", 10, false, false}, {">=", 0, "<=", -1, false, false}, {">=", 0, "<=", -10, false, false}, {">=", 0, "<=", 10, false, false}, {">=", 0, ">=", 1, true, false}, {">=", 0, ">=", 10, true, false}, {"<", 0, "<", 1, false, true}, {"<", 0, "<", 10, false, true}, {"<", 0, "<=", 0, false, true}, {"<", 0, "<=", 10, false, true}, {"<=", 0, "<=", 1, false, true}, {"<=", 0, "<=", 10, false, true}, {">", 0, ">=", 1, true, true}, {"<", 0, "<=", -1, true, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testASubsumesB(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.initNumericIntegerConditionInspectorSubsumptionTest(operator1, value1, operator2, value2, aSubsumesB, bSubsumesA);
        NumericIntegerConditionInspector a = this.getCondition(value1, operator1);
        NumericIntegerConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.subsumes((Object)b)).as(this.getAssertDescription(a, b, aSubsumesB), new Object[0])).isEqualTo(aSubsumesB);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testBSubsumesA(String operator1, Integer value1, String operator2, Integer value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.initNumericIntegerConditionInspectorSubsumptionTest(operator1, value1, operator2, value2, aSubsumesB, bSubsumesA);
        NumericIntegerConditionInspector a = this.getCondition(value1, operator1);
        NumericIntegerConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.subsumes((Object)a)).as(this.getAssertDescription(b, a, bSubsumesA), new Object[0])).isEqualTo(bSubsumesA);
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean subsumptionExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), subsumptionExpected ? "" : "not ", b.toHumanReadableString());
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

