/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ChangeHandledMultiMapTest {
    private MultiMap<Value, String, List<String>> map;
    private MultiMapChangeHandler.ChangeSet<Value, String> changeSet;
    private int timesCalled = 0;

    @BeforeEach
    public void setUp() throws Exception {
        this.timesCalled = 0;
        this.map = MultiMapFactory.make((boolean)true);
        this.map.addChangeListener((MultiMapChangeHandler)new MultiMapChangeHandler<Value, String>(){

            public void onChange(MultiMapChangeHandler.ChangeSet<Value, String> changeSet) {
                ChangeHandledMultiMapTest.this.changeSet = changeSet;
                ChangeHandledMultiMapTest.this.timesCalled++;
            }
        });
    }

    @Test
    void testSize() throws Exception {
        Assertions.assertThat(this.changeSet).isNull();
        Assertions.assertThat((int)this.timesCalled).isEqualTo(0);
    }

    @Test
    void testPut() throws Exception {
        this.map.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"test");
        Assertions.assertThat((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("test")).isTrue();
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }

    @Test
    void testAddAllValues() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        this.map.addAllValues((Comparable)new Value((Comparable)((Object)"hello")), list);
        Assertions.assertThat((int)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).size()).isEqualTo(3);
        Assertions.assertThat((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("a")).isTrue();
        Assertions.assertThat((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("b")).isTrue();
        Assertions.assertThat((boolean)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello"))).contains("c")).isTrue();
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }
}

