/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class ComparableConditionInspectorConflictResolverTest {
    private Field field;
    private Comparable value1;
    private Comparable value2;
    private String operator1;
    private String operator2;
    private boolean conflictExpected;

    public void initComparableConditionInspectorConflictResolverTest(String operator1, Comparable value1, String operator2, Comparable value2, boolean conflictExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.conflictExpected = conflictExpected;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0.5, "==", 0.5, false}, {"!=", 0.5, "!=", 0.5, false}, {">", 0.5, ">", 0.5, false}, {">=", 0.5, ">=", 0.5, false}, {"<", 0.5, "<", 0.5, false}, {"<=", 0.5, "<=", 0.5, false}, {"==", 0.5, "!=", 1.5, false}, {"==", 0.5, ">", -1.5, false}, {"==", 0.5, ">", -10.5, false}, {"==", 0.5, ">=", 0.5, false}, {"==", 0.5, ">=", -10.5, false}, {"==", 0.5, "<", 1.5, false}, {"==", 0.5, "<", 10.5, false}, {"==", 0.5, "<=", 0.5, false}, {"==", 0.5, "<=", 10.5, false}, {"==", 0.5, "==", 1.5, true}, {"==", 0.5, "!=", 0.5, true}, {"==", 0.5, ">", 0.5, true}, {"==", 0.5, ">", 10.5, true}, {"==", 0.5, ">=", 1.5, true}, {"==", 0.5, ">=", 10.5, true}, {"==", 0.5, "<", 0.5, true}, {"==", 0.5, "<", -10.5, true}, {"==", 0.5, "<=", -1.5, true}, {"==", 0.5, "<=", -10.5, true}, {"!=", 0.5, "!=", 1.5, false}, {"!=", 0.5, ">", -1.5, false}, {"!=", 0.5, ">=", 0.5, false}, {"!=", 0.5, "<", 1.5, false}, {"!=", 0.5, "<=", 0.5, false}, {">", 0.5, ">", 1.5, false}, {">", 0.5, ">=", 0.5, false}, {">", 0.5, "<", 2.5, false}, {">", 0.5, "<", 10.5, false}, {">", 0.5, "<=", 1.5, false}, {">", 0.5, "<=", 10.5, false}, {">", 0.5, "<", -1.5, true}, {">", 0.5, "<", 0.5, true}, {">", 0.5, "<", 1.5, false}, {">", 0.5, "<=", -2.5, true}, {">", 0.5, "<=", -1.5, true}, {">", 0.5, "<=", 0.5, true}, {">=", 0.5, ">=", 1.5, false}, {">=", 0.5, "<", 1.5, false}, {">=", 0.5, "<", 10.5, false}, {">=", 0.5, "<=", 0.5, false}, {">=", 0.5, "<=", 10.5, false}, {">=", 0.5, "<", -2.5, true}, {">=", 0.5, "<", -1.5, true}, {">=", 0.5, "<", 0.5, true}, {">=", 0.5, "<=", -3.5, true}, {">=", 0.5, "<=", -2.5, true}, {">=", 0.5, "<=", -1.5, true}, {"<", 0.5, "<", 1.5, false}, {"<", 0.5, "<=", 0.5, false}, {"<=", 0.5, "<=", 1.5, false}, {"after", new Date(0L), "after", new Date(0L), false}, {"before", new Date(0L), "before", new Date(0L), false}, {"after", new Date(10000L), "before", new Date(20000L), false}, {"after", new Date(20000L), "before", new Date(10000L), true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(String operator1, Comparable value1, String operator2, Comparable value2, boolean conflictExpected) {
        this.initComparableConditionInspectorConflictResolverTest(operator1, value1, operator2, value2, conflictExpected);
        ComparableConditionInspector a = this.getCondition(value1, operator1);
        ComparableConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescriptionConflict(a, b, conflictExpected), new Object[0])).isEqualTo(conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescriptionConflict(a, b, conflictExpected), new Object[0])).isEqualTo(conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescriptionOverlap(a, b, !conflictExpected), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescriptionOverlap(b, a, !conflictExpected), new Object[0])).isEqualTo(!conflictExpected);
    }

    private String getAssertDescriptionConflict(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto conflict with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    private String getAssertDescriptionOverlap(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto overlap with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    private ComparableConditionInspector getCondition(Comparable value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{value}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

