/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.AllListener;
import org.drools.verifier.core.index.select.FirstListener;
import org.drools.verifier.core.index.select.LastListener;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListenRemoveTest {
    private Listen<Person> listen;
    private MultiMap<Value, Person, List<Person>> map;
    private Collection<Person> all;
    private Person first;
    private Person last;
    private Person baby;
    private Person teenager;
    private Person grandpa;

    @BeforeEach
    public void setUp() throws Exception {
        this.map = MultiMapFactory.make((boolean)true);
        this.baby = new Person(0, "baby");
        this.teenager = new Person(15, "teenager");
        this.grandpa = new Person(100, "grandpa");
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)this.baby);
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(15)), (Object)this.teenager);
        this.map.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)this.grandpa);
        this.listen = new Listen(this.map, (Matcher)new ExactMatcher(KeyDefinition.newKeyDefinition().withId("ID").build(), (Comparable)((Object)"notInTheList"), true));
        this.listen.all((AllListener)new AllListener<Person>(){

            public void onAllChanged(Collection<Person> all) {
                ListenRemoveTest.this.all = all;
            }
        });
        this.listen.first((FirstListener)new FirstListener<Person>(){

            public void onFirstChanged(Person first) {
                ListenRemoveTest.this.first = first;
            }
        });
        this.listen.last((LastListener)new LastListener<Person>(){

            public void onLastChanged(Person last) {
                ListenRemoveTest.this.last = last;
            }
        });
    }

    @Test
    void testBeginning() throws Exception {
        this.map.remove((Comparable)new Value((Comparable)Integer.valueOf(0)));
        Assertions.assertThat((Object)this.first).isEqualTo((Object)this.teenager);
        Assertions.assertThat((Object)this.last).isNull();
        Assertions.assertThat((int)this.all.size()).isEqualTo(2);
    }

    @Test
    void testEnd() throws Exception {
        this.map.remove((Comparable)new Value((Comparable)Integer.valueOf(100)));
        Assertions.assertThat((Object)this.first).isNull();
        Assertions.assertThat((Object)this.last).isEqualTo((Object)this.teenager);
        Assertions.assertThat((int)this.all.size()).isEqualTo(2);
    }

    @Test
    void testMiddle() throws Exception {
        this.map.remove((Comparable)new Value((Comparable)Integer.valueOf(15)));
        Assertions.assertThat((Object)this.first).isNull();
        Assertions.assertThat((Object)this.last).isNull();
        Assertions.assertThat((int)this.all.size()).isEqualTo(2);
    }

    class Person {
        int age;
        String name;

        public Person(int age, String name) {
            this.age = age;
            this.name = name;
        }
    }
}

