/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class BooleanConditionInspectorTest {
    private boolean value1;
    private boolean value2;
    private String operator1;
    private String operator2;
    private boolean conflictExpected;
    private Field field;

    public void initBooleanConditionInspectorTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.conflictExpected = conflictExpected;
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedConflictTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.initBooleanConditionInspectorTest(operator1, value1, operator2, value2, conflictExpected);
        BooleanConditionInspector a = this.getCondition(value1, operator1);
        BooleanConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription(a, b, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription(b, a, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedRedundancyTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.initBooleanConditionInspectorTest(operator1, value1, operator2, value2, conflictExpected);
        BooleanConditionInspector a = this.getCondition(value1, operator1);
        BooleanConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(this.getAssertDescription(a, b, !conflictExpected, "be redundant"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(this.getAssertDescription(b, a, !conflictExpected, "be redundant"), new Object[0])).isEqualTo(!conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedOverlapTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.initBooleanConditionInspectorTest(operator1, value1, operator2, value2, conflictExpected);
        BooleanConditionInspector a = this.getCondition(value1, operator1);
        BooleanConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription(a, b, !conflictExpected, "overlap"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription(b, a, !conflictExpected, "overlap"), new Object[0])).isEqualTo(!conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedSubsumptionTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        this.initBooleanConditionInspectorTest(operator1, value1, operator2, value2, conflictExpected);
        BooleanConditionInspector a = this.getCondition(value1, operator1);
        BooleanConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.subsumes((Object)b)).as(this.getAssertDescription(a, b, !conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.subsumes((Object)a)).as(this.getAssertDescription(b, a, !conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!conflictExpected);
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"!=", true, "!=", true, false}, {"==", true, "==", true, false}, {"!=", true, "==", false, false}, {"!=", true, "!=", false, true}, {"==", true, "==", false, true}, {"!=", true, "==", true, true});
    }

    private String getAssertDescription(BooleanConditionInspector a, BooleanConditionInspector b, boolean conditionExpected, String condition) {
        return String.format("Expected conditions '%s' and '%s' %sto %s:", a.toHumanReadableString(), b.toHumanReadableString(), conditionExpected ? "" : "not ", condition);
    }

    private BooleanConditionInspector getCondition(boolean value, String operator) {
        return new BooleanConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Boolean.valueOf(value)}), (AnalyzerConfiguration)new AnalyzerConfigurationMock()), (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }
}

