/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class NumericIntegerConditionInspectorSubsumptionResolverTest {
    private Integer value1;
    private Integer value2;
    private String operator1;
    private String operator2;
    private boolean redundancyExpected;
    private Field field;

    public void initNumericIntegerConditionInspectorSubsumptionResolverTest(String operator1, Integer value1, String operator2, Integer value2, boolean redundancyExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.redundancyExpected = redundancyExpected;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"!=", 0, "!=", 1, false}, {">", 0, ">", 1, false}, {">=", 0, ">=", 1, false}, {"<", 0, "<", 1, false}, {"<=", 0, "<=", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">=", 0, false}, {"==", 0, "<", 0, false}, {"==", 0, "<=", 0, false}, {"!=", 0, ">", 0, false}, {"!=", 0, ">=", 0, false}, {"!=", 0, "<", 0, false}, {"!=", 0, "<=", 0, false}, {">", 0, ">=", 0, false}, {">", 0, "<", 0, false}, {">", 0, "<=", 0, false}, {">=", 0, "<", 0, false}, {">=", 0, "<=", 0, false}, {"<", 0, "<=", 0, false}, {"==", 0, "!=", 1, false}, {"==", 0, ">", 1, false}, {"==", 0, ">=", 1, false}, {"==", 0, "<", 1, false}, {"==", 0, "<=", 1, false}, {"!=", 0, ">", 1, false}, {"!=", 0, ">=", 1, false}, {"!=", 0, "<", 1, false}, {"!=", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {">", 0, "<", 1, false}, {">", 0, "<=", 1, false}, {">=", 0, "<", 1, false}, {">=", 0, "<=", 1, false}, {"<", 0, "<=", 1, false}, {">", 0, ">=", 1, true}, {"<", 1, "<=", 0, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(String operator1, Integer value1, String operator2, Integer value2, boolean redundancyExpected) {
        this.initNumericIntegerConditionInspectorSubsumptionResolverTest(operator1, value1, operator2, value2, redundancyExpected);
        NumericIntegerConditionInspector a = this.getCondition(value1, operator1);
        NumericIntegerConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(this.getAssertDescription(a, b, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(this.getAssertDescription(b, a, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

