/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class StringConditionInspectorSubsumptionResolverTest {
    private Values value1;
    private Values value2;
    private String operator1;
    private String operator2;
    private boolean redundancyExpected;
    private Field field;

    public void initStringConditionInspectorSubsumptionResolverTest(String operator1, Values value1, String operator2, Values value2, boolean redundancyExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.redundancyExpected = redundancyExpected;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"a"}), true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), true}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), true}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), true}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), true}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"a", "b"}), true}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), true}, {"matches", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true}, {"soundslike", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true}, {"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"b"}), false}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a"}), true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"b"}), false}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"in", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b"}), false}, {"in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"b", "a"}), true}, {"not in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b"}), false}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"b", "a"}), true}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false}, {"<", new Values(new Comparable[]{"b"}), "<=", new Values(new Comparable[]{"a"}), false});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(String operator1, Values value1, String operator2, Values value2, boolean redundancyExpected) {
        this.initStringConditionInspectorSubsumptionResolverTest(operator1, value1, operator2, value2, redundancyExpected);
        StringConditionInspector a = this.getCondition(value1, operator1);
        StringConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(this.getAssertDescription(a, b, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(this.getAssertDescription(b, a, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    private StringConditionInspector getCondition(Values values, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new StringConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, values, (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

