/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.PairCheck;
import org.drools.verifier.core.checks.base.PairCheckBundle;
import org.drools.verifier.core.checks.base.PairCheckStorage;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class PairCheckStorageListTest {
    private PairCheckStorage pairCheckStorage;
    @Mock
    private RuleInspector a;
    @Mock
    private RuleInspector b;
    @Mock
    private RuleInspector c;
    private PairCheckBundle pairCheckListOne;
    private PairCheckBundle pairCheckListTwo;

    @BeforeEach
    public void setUp() throws Exception {
        this.pairCheckStorage = new PairCheckStorage();
        this.pairCheckListOne = new PairCheckBundle(this.a, this.b, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListOne);
        this.pairCheckListTwo = new PairCheckBundle(this.b, this.a, this.newMockList());
        this.pairCheckStorage.add(this.pairCheckListTwo);
        this.pairCheckStorage.add(new PairCheckBundle(this.a, this.c, this.newMockList()));
        this.pairCheckStorage.add(new PairCheckBundle(this.c, this.a, this.newMockList()));
    }

    private List<Check> newMockList() {
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.add((Check)Mockito.mock(PairCheck.class));
        return checks;
    }

    @Test
    void getA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.a);
        Assertions.assertThat((int)pairCheckLists.size()).isEqualTo(4);
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListOne)).isTrue();
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListTwo)).isTrue();
    }

    @Test
    void getB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.get(this.b);
        Assertions.assertThat((int)pairCheckLists.size()).isEqualTo(2);
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListOne)).isTrue();
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListTwo)).isTrue();
    }

    @Test
    void removeB() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.b);
        Assertions.assertThat((int)pairCheckLists.size()).isEqualTo(2);
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListOne)).isTrue();
        Assertions.assertThat((boolean)pairCheckLists.contains(this.pairCheckListTwo)).isTrue();
        Assertions.assertThat((boolean)this.pairCheckStorage.get(this.b).isEmpty()).isTrue();
        Collection pairChecksForAList = this.pairCheckStorage.get(this.a);
        Assertions.assertThat((int)pairChecksForAList.size()).isEqualTo(2);
        Assertions.assertThat((boolean)pairChecksForAList.contains(this.pairCheckListOne)).isFalse();
        Assertions.assertThat((boolean)pairChecksForAList.contains(this.pairCheckListTwo)).isFalse();
    }

    @Test
    void removeA() throws Exception {
        Collection pairCheckLists = this.pairCheckStorage.remove(this.a);
        Assertions.assertThat((int)pairCheckLists.size()).isEqualTo(4);
        Assertions.assertThat((boolean)this.pairCheckStorage.get(this.a).isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.pairCheckStorage.get(this.b).isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.pairCheckStorage.get(this.c).isEmpty()).isTrue();
    }
}

