/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SelectExactMatcherNegateTest {
    private int amount;
    private Select<Item> select;
    private Object firstValue;
    private Object lastValue;

    private MultiMap<Value, Item, List<Item>> makeMap() {
        MultiMap itemKeyTreeMap = MultiMapFactory.make();
        itemKeyTreeMap.put((Comparable)new Value(null), (Object)new Item(null));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)new Item(0));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(56)), (Object)new Item(56));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)new Item(100));
        itemKeyTreeMap.put((Comparable)new Value((Comparable)Integer.valueOf(1200)), (Object)new Item(1200));
        return itemKeyTreeMap;
    }

    public void initSelectExactMatcherNegateTest(int amount, Object firstValue, Object lastValue, Matcher matcher) throws Exception {
        this.firstValue = firstValue;
        this.lastValue = lastValue;
        this.amount = amount;
        this.select = new Select(this.makeMap(), matcher);
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({5, null, 1200, new ExactMatcher(KeyDefinition.newKeyDefinition().withId("cost").build(), (Comparable)Integer.valueOf(13), true)}, {4, 0, 1200, new ExactMatcher(KeyDefinition.newKeyDefinition().withId("cost").build(), null, true)});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testAll(int amount, Object firstValue, Object lastValue, Matcher matcher) throws Exception {
        this.initSelectExactMatcherNegateTest(amount, firstValue, lastValue, matcher);
        Collection all = this.select.all();
        Assertions.assertThat((int)all.size()).isEqualTo(amount);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testFirst(int amount, Object firstValue, Object lastValue, Matcher matcher) throws Exception {
        this.initSelectExactMatcherNegateTest(amount, firstValue, lastValue, matcher);
        Assertions.assertThat((Integer)((Item)this.select.first()).cost).isEqualTo(firstValue);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void testLast(int amount, Object firstValue, Object lastValue, Matcher matcher) throws Exception {
        this.initSelectExactMatcherNegateTest(amount, firstValue, lastValue, matcher);
        Assertions.assertThat((Integer)((Item)this.select.last()).cost).isEqualTo(lastValue);
    }

    private class Item {
        private Integer cost;

        public Item(Integer cost) {
            this.cost = cost;
        }
    }
}

