/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class DoubleComparableConditionInspectorCoverTest {
    private Comparable conditionValue;
    private Comparable value;
    private String conditionOperator;
    private boolean coverExpected;
    private Field field;

    public void initDoubleComparableConditionInspectorCoverTest(Comparable conditionValue, String conditionOperator, Comparable value, boolean coverExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.conditionValue = conditionValue;
        this.value = value;
        this.conditionOperator = conditionOperator;
        this.coverExpected = coverExpected;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({0.5, "==", 0.5, true}, {0.5, "<", 0.5, false}, {0.5, "<", 10.5, false}, {10.5, "<", 0.5, true}, {0.5, ">", 0.5, false}, {0.5, ">", 10.5, true}, {10.5, "==", 0.5, false}, {0.5, "==", 10.5, false}, {10.5, ">", 0.5, false}, {-1.5, ">", 0.5, true}, {0.5, ">", -1.5, false}, {-1.5, "==", 0.5, false}, {0.5, "==", -1.5, false}, {new Date(0L), "==", new Date(0L), true}, {new Date(0L), "==", new Date(1L), false}, {new Date(0L), "!=", new Date(0L), false}, {new Date(0L), "!=", new Date(1L), true}, {new Date(0L), "after", new Date(1L), true}, {new Date(1L), "after", new Date(0L), false}, {new Date(0L), "before", new Date(1L), false}, {new Date(1L), "before", new Date(0L), true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(Comparable conditionValue, String conditionOperator, Comparable value, boolean coverExpected) {
        this.initDoubleComparableConditionInspectorCoverTest(conditionValue, conditionOperator, value, coverExpected);
        ComparableConditionInspector a = this.getCondition(conditionValue, conditionOperator);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.covers(value)).as(this.getAssertDescription(a, value, coverExpected), new Object[0])).isEqualTo(coverExpected);
    }

    private String getAssertDescription(ComparableConditionInspector a, Comparable b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto cover value '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toString());
    }

    private ComparableConditionInspector getCondition(Comparable value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{value}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

