/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.HashSet;
import java.util.List;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.RedundantConditionsIssue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.PatternInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.maps.InspectorMultiMap;
import org.drools.verifier.core.maps.util.RedundancyResult;

public class DetectRedundantConditionsCheck
extends SingleCheck {
    private RedundancyResult<ObjectField, ConditionInspector> result;

    public DetectRedundantConditionsCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.REDUNDANT_CONDITIONS_TITLE);
    }

    @Override
    public boolean check() {
        this.result = this.ruleInspector.getPatternsInspector().stream().map(PatternInspector::getConditionsInspector).map(InspectorMultiMap::hasRedundancy).filter(RedundancyResult::isTrue).findFirst().orElse(null);
        this.hasIssues = this.result != null;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new RedundantConditionsIssue(severity, checkType, this.result.getParent().getFactType(), this.result.getParent().getName(), this.result.get(0).toHumanReadableString(), this.result.get(1).toHumanReadableString(), new HashSet<Integer>(List.of(Integer.valueOf(this.ruleInspector.getRowIndex() + 1))));
    }
}

