/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class NumericIntegerConditionInspectorConflictResolverOverlapTest {
    private Integer value1;
    private Integer value2;
    private String operator1;
    private String operator2;
    private boolean overlapExpected;
    private Field field;

    public void initNumericIntegerConditionInspectorConflictResolverOverlapTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        this.field = (Field)Mockito.mock(Field.class);
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.overlapExpected = overlapExpected;
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0, "==", 0, true}, {"!=", 0, "!=", 0, true}, {">", 0, ">", 0, true}, {">=", 0, ">=", 0, true}, {"<", 0, "<", 0, true}, {"<=", 0, "<=", 0, true}, {"==", 0, "==", 1, false}, {"==", 0, "!=", 0, false}, {"==", 0, ">", 0, false}, {"==", 0, ">", 10, false}, {"==", 0, ">=", 1, false}, {"==", 0, ">=", 10, false}, {"==", 0, "<", 0, false}, {"==", 0, "<", -10, false}, {"==", 0, "<=", -1, false}, {"==", 0, "<=", -10, false}, {"==", 0, "!=", 1, true}, {"==", 0, ">", -1, true}, {"==", 0, ">", -10, true}, {"==", 0, ">=", 0, true}, {"==", 0, ">=", -10, true}, {"==", 0, "<", 1, true}, {"==", 0, "<", 10, true}, {"==", 0, "<=", 0, true}, {"==", 0, "<=", 10, true}, {"!=", 0, "!=", 1, true}, {"!=", 0, ">", -1, true}, {"!=", 0, ">", -10, true}, {"!=", 0, ">=", 0, true}, {"!=", 0, ">=", -10, true}, {"!=", 0, "<", 1, true}, {"!=", 0, "<", 10, true}, {"!=", 0, "<=", 0, true}, {"!=", 0, "<=", 10, true}, {">", 0, "<", 1, true}, {">", 0, "<", -10, false}, {">", 0, "<=", 0, false}, {">", 0, "<=", -10, false}, {">", 0, ">", -1, true}, {">", 0, ">", -10, true}, {">", 0, ">=", 0, true}, {">", 0, ">=", 1, true}, {">", 0, ">=", -10, true}, {">", 0, "<", 2, true}, {">", 0, "<", 10, true}, {">", 0, "<=", 1, true}, {">", 0, "<=", 10, true}, {">=", 0, "<", 0, false}, {">=", 0, "<", -10, false}, {">=", 0, "<=", -1, false}, {">=", 0, "<=", -10, false}, {">=", 0, ">=", 1, true}, {">=", 0, ">=", -10, true}, {">=", 0, "<", 1, true}, {">=", 0, "<", 10, true}, {">=", 0, "<=", 0, true}, {">=", 0, "<=", 10, true}, {"<", 0, "<", 1, true}, {"<", 0, "<", 10, true}, {"<", 0, "<=", -1, true}, {"<", 0, "<=", 0, true}, {"<", 0, "<=", 10, true}, {"<=", 0, "<=", -1, true}, {"<=", 0, "<=", 10, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedOverlapTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        this.initNumericIntegerConditionInspectorConflictResolverOverlapTest(operator1, value1, operator2, value2, overlapExpected);
        NumericIntegerConditionInspector a = this.getCondition(value1, operator1);
        NumericIntegerConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription(a, b, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription(b, a, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedConflictTest(String operator1, Integer value1, String operator2, Integer value2, boolean overlapExpected) {
        this.initNumericIntegerConditionInspectorConflictResolverOverlapTest(operator1, value1, operator2, value2, overlapExpected);
        NumericIntegerConditionInspector a = this.getCondition(value1, operator1);
        NumericIntegerConditionInspector b = this.getCondition(value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription(a, b, !overlapExpected, "conflict"), new Object[0])).isEqualTo(!overlapExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription(b, a, !overlapExpected, "conflict"), new Object[0])).isEqualTo(!overlapExpected);
    }

    private String getAssertDescription(NumericIntegerConditionInspector a, NumericIntegerConditionInspector b, boolean conflictExpected, String condition) {
        return String.format("Expected condition '%s' %sto %s with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", condition, b.toHumanReadableString());
    }

    private NumericIntegerConditionInspector getCondition(int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{Integer.valueOf(value)}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

