/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.HashSet;
import java.util.List;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;

public class DetectMissingConditionCheck
extends SingleCheck {
    public DetectMissingConditionCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.MISSING_RESTRICTION);
    }

    @Override
    public boolean check() {
        this.hasIssues = this.ruleInspector.atLeastOneActionHasAValue() && !this.ruleInspector.atLeastOneConditionHasAValue();
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(List.of(Integer.valueOf(this.ruleInspector.getRowIndex() + 1))));
    }
}

