/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StringConditionInspectorOverlapTest {
    @Mock
    private Field field;

    @Test
    void test001() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    void test002() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Eder"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test003() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test004() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael", "Eder"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test005() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Eder"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    void test006() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Eder"}), "!=");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test007() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Eder", "John"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    void test008() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Michael"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni", "Eder"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test009() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "in");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Eder", "Toni"}), "in");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }

    @Test
    void test010() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{""}), "==");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{""}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isFalse();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isFalse();
    }

    @Test
    void test011() throws Exception {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "==");
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, new Values(new Comparable[]{"Toni"}), "==");
        Assertions.assertThat((boolean)a.overlaps((Object)b)).isTrue();
        Assertions.assertThat((boolean)b.overlaps((Object)a)).isTrue();
    }
}

