/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index;

import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.Conditions;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.index.select.AllListener;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ConditionsListenerTest {
    private Conditions conditions;
    private AllListener allListener;
    private AnalyzerConfigurationMock configuration;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.conditions = new Conditions();
        this.allListener = (AllListener)Mockito.mock(AllListener.class);
        ((Conditions.ConditionListen)this.conditions.where(Condition.value().any()).listen()).all(this.allListener);
    }

    @Test
    void testListen() throws Exception {
        this.conditions.add((Condition)new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)this.configuration), new Column(1, (AnalyzerConfiguration)this.configuration), "==", new Values(new Comparable[]{Integer.valueOf(10)}), (AnalyzerConfiguration)this.configuration));
        ((AllListener)Mockito.verify((Object)this.allListener)).onAllChanged(Mockito.anyCollection());
    }

    @Test
    void testUpdate() throws Exception {
        FieldCondition condition = new FieldCondition(new Field((ObjectField)Mockito.mock(ObjectField.class), "Person", "String", "name", (AnalyzerConfiguration)this.configuration), new Column(1, (AnalyzerConfiguration)this.configuration), "==", new Values(new Comparable[]{Integer.valueOf(10)}), (AnalyzerConfiguration)this.configuration);
        this.conditions.add((Condition)condition);
        Mockito.reset((Object[])new AllListener[]{this.allListener});
        condition.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((AllListener)Mockito.verify((Object)this.allListener)).onAllChanged(Mockito.anyCollection());
    }
}

