/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KeyTreeMapMultiValueKeyTest {
    private final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private final KeyDefinition AREA_CODE = KeyDefinition.newKeyDefinition().withId("areaCode").build();
    private KeyTreeMap<Country> map;
    private Country norway;
    private Country finland;
    private Country sweden;
    private AnalyzerConfiguration configuration;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.map = new KeyTreeMap(new KeyDefinition[]{this.NAME, this.AREA_CODE});
        this.finland = new Country("Finland", 48100);
        this.sweden = new Country("Sweden", 12345, 51000);
        this.norway = new Country("Norway", 0, 51000);
        this.map.put((HasKeys)this.finland);
        this.map.put((HasKeys)this.sweden);
        this.map.put((HasKeys)this.norway);
    }

    @Test
    void testFindByUUID() throws Exception {
        Assertions.assertThat((Collection)this.map.get(UUIDKey.UNIQUE_UUID).keySet()).containsExactlyInAnyOrder((Object[])new Value[]{this.finland.uuidKey.getSingleValue(), this.sweden.uuidKey.getSingleValue(), this.norway.uuidKey.getSingleValue()});
    }

    @Test
    void testFindByAreaCodeKey() throws Exception {
        Assertions.assertThat((Collection)this.map.get(this.AREA_CODE).keySet()).extracting(x -> x.getComparable()).containsExactlyInAnyOrder((Object[])new Comparable[]{Integer.valueOf(48100), Integer.valueOf(12345), Integer.valueOf(51000), Integer.valueOf(0)});
    }

    @Test
    void testFindByAreaCode() throws Exception {
        MultiMap areaCode = this.map.get(this.AREA_CODE);
        ((ListAssert)Assertions.assertThat((List)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(48100)))).hasSize(1)).contains((Object[])new Country[]{this.finland});
        ((ListAssert)Assertions.assertThat((List)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(12345)))).hasSize(1)).contains((Object[])new Country[]{this.sweden});
        ((ListAssert)Assertions.assertThat((List)areaCode.get((Comparable)new Value((Comparable)Integer.valueOf(51000)))).hasSize(2)).contains((Object[])new Country[]{this.sweden, this.norway});
    }

    class Country
    implements HasKeys {
        final String name;
        private final UUIDKey uuidKey;
        private UpdatableKey areaCode;

        public Country(String name, Integer ... areaCodes) {
            this.uuidKey = KeyTreeMapMultiValueKeyTest.this.configuration.getUUID((HasKeys)this);
            this.name = name;
            this.areaCode = new UpdatableKey(KeyTreeMapMultiValueKeyTest.this.AREA_CODE, new Values((Comparable[])areaCodes));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyTreeMapMultiValueKeyTest.this.NAME, (Comparable)((Object)this.name)), this.areaCode};
        }

        public void setAge(Integer ... areaCodes) {
            UpdatableKey newKey;
            UpdatableKey oldKey = this.areaCode;
            this.areaCode = newKey = new UpdatableKey(KeyTreeMapMultiValueKeyTest.this.AREA_CODE, new Values((Comparable[])areaCodes));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

