/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StringConditionInspectorSubsumptionResolverTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"a"}), true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), true}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), true}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), true}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), true}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"a", "b"}), true}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), true}, {"matches", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true}, {"soundslike", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true}, {"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"b"}), false}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a"}), true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"b"}), false}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"in", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b"}), false}, {"in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"b", "a"}), true}, {"not in", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b"}), false}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"b", "a"}), true}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"b"}), false}, {"<", new Values(new Comparable[]{"b"}), "<=", new Values(new Comparable[]{"a"}), false});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedTest(String operator1, Values value1, String operator2, Values value2, boolean redundancyExpected) {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, value1, operator1);
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)a, (ComparableConditionInspector)b, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(ConditionInspectorUtils.getAssertDescriptionForRedundant((ComparableConditionInspector)b, (ComparableConditionInspector)a, redundancyExpected), new Object[0])).isEqualTo(redundancyExpected);
    }
}

