/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.select;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SelectWithNegativeExactMatcherWhenTheValueIsNotInTheMapTest {
    private Select<Item> select;

    private MultiMap<Value, Item, List<Item>> makeMap() {
        MultiMap map = MultiMapFactory.make((boolean)false);
        map.put((Comparable)new Value((Comparable)Integer.valueOf(0)), (Object)new Item(0));
        map.put((Comparable)new Value((Comparable)Integer.valueOf(56)), (Object)new Item(56));
        map.put((Comparable)new Value((Comparable)Integer.valueOf(100)), (Object)new Item(100));
        map.put((Comparable)new Value((Comparable)Integer.valueOf(1200)), (Object)new Item(1200));
        return map;
    }

    private void fill(KeyTreeMap<Item> itemKeyTreeMap, Item item) {
        itemKeyTreeMap.put((HasKeys)item);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.select = new Select(this.makeMap(), (Matcher)new ExactMatcher(null, (Comparable)((Object)"cost"), true));
    }

    @Test
    void testAll() throws Exception {
        Collection all = this.select.all();
        Assertions.assertThat((Collection)all).hasSize(4);
    }

    @Test
    void testFirst() throws Exception {
        Assertions.assertThat((int)((Item)this.select.first()).cost).isEqualTo(0);
    }

    @Test
    void testLast() throws Exception {
        Assertions.assertThat((int)((Item)this.select.last()).cost).isEqualTo(1200);
    }

    private class Item
    implements HasKeys {
        private int cost;
        private UUIDKey uuidKey = new AnalyzerConfigurationMock().getUUID(this);

        public Item(int cost) {
            this.cost = cost;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyDefinition.newKeyDefinition().withId("cost").build(), (Comparable)Integer.valueOf(this.cost))};
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

