/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BooleanConditionInspectorTest {
    @Mock
    private Field field;

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedConflictTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        BooleanConditionInspector a = ConditionInspectorUtils.getBooleanCondition(this.field, value1, operator1);
        BooleanConditionInspector b = ConditionInspectorUtils.getBooleanCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.conflicts((Object)b)).as(this.getAssertDescription((ComparableConditionInspector)a, (ComparableConditionInspector)b, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.conflicts((Object)a)).as(this.getAssertDescription((ComparableConditionInspector)b, (ComparableConditionInspector)a, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedRedundancyTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        BooleanConditionInspector a = ConditionInspectorUtils.getBooleanCondition(this.field, value1, operator1);
        BooleanConditionInspector b = ConditionInspectorUtils.getBooleanCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.isRedundant((Object)b)).as(this.getAssertDescription((ComparableConditionInspector)a, (ComparableConditionInspector)b, !conflictExpected, "be redundant"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.isRedundant((Object)a)).as(this.getAssertDescription((ComparableConditionInspector)b, (ComparableConditionInspector)a, !conflictExpected, "be redundant"), new Object[0])).isEqualTo(!conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedOverlapTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        BooleanConditionInspector a = ConditionInspectorUtils.getBooleanCondition(this.field, value1, operator1);
        BooleanConditionInspector b = ConditionInspectorUtils.getBooleanCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.overlaps((Object)b)).as(this.getAssertDescription((ComparableConditionInspector)a, (ComparableConditionInspector)b, !conflictExpected, "overlap"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.overlaps((Object)a)).as(this.getAssertDescription((ComparableConditionInspector)b, (ComparableConditionInspector)a, !conflictExpected, "overlap"), new Object[0])).isEqualTo(!conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedSubsumptionTest(String operator1, boolean value1, String operator2, boolean value2, boolean conflictExpected) {
        BooleanConditionInspector a = ConditionInspectorUtils.getBooleanCondition(this.field, value1, operator1);
        BooleanConditionInspector b = ConditionInspectorUtils.getBooleanCondition(this.field, value2, operator2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)a.subsumes((Object)b)).as(this.getAssertDescription((ComparableConditionInspector)a, (ComparableConditionInspector)b, !conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!conflictExpected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)b.subsumes((Object)a)).as(this.getAssertDescription((ComparableConditionInspector)b, (ComparableConditionInspector)a, !conflictExpected, "be subsuming"), new Object[0])).isEqualTo(!conflictExpected);
    }

    public static Collection<Object[]> testData() {
        return Arrays.asList({"!=", true, "!=", true, false}, {"==", true, "==", true, false}, {"!=", true, "==", false, false}, {"!=", true, "!=", false, true}, {"==", true, "==", false, true}, {"!=", true, "==", true, true});
    }

    private String getAssertDescription(ComparableConditionInspector a, ComparableConditionInspector b, boolean conditionExpected, String condition) {
        return String.format("Expected conditions '%s' and '%s' %sto %s:", a.toHumanReadableString(), b.toHumanReadableString(), conditionExpected ? "" : "not ", condition);
    }
}

