/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Collection;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.query.Where;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.IndexedKeyTreeMap;

public class Columns {
    public final IndexedKeyTreeMap<Column> map = new IndexedKeyTreeMap(Column.keyDefinitions());

    public Columns() {
    }

    public Columns(Collection<Column> columns) {
        for (Column column : columns) {
            this.add(column);
        }
    }

    public void add(Column column) {
        this.map.put(column, column.getIndex());
    }

    public void merge(Columns columns) {
        this.map.merge(columns.map);
    }

    public Where<ColumnSelect, ColumnListen> where(final Matcher matcher) {
        return new Where<ColumnSelect, ColumnListen>(){

            @Override
            public ColumnSelect select() {
                return new ColumnSelect(matcher);
            }

            @Override
            public ColumnListen listen() {
                return new ColumnListen(matcher);
            }
        };
    }

    public void remove(Column column) {
        column.getUuidKey().retract();
    }

    public class ColumnListen
    extends Listen<Column> {
        public ColumnListen(Matcher matcher) {
            super(Columns.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ColumnSelect
    extends Select<Column> {
        public ColumnSelect(Matcher matcher) {
            super(Columns.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }
}

