/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.util.HasKeys;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class KeyTreeMapTest {
    private final KeyDefinition AGE = KeyDefinition.newKeyDefinition().updatable().withId("age").build();
    private final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private KeyTreeMap<Person> map;
    private Person toni;
    private Person eder;
    private Person michael;
    private AnalyzerConfiguration configuration;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.map = new KeyTreeMap(new KeyDefinition[]{this.AGE, this.NAME});
        this.toni = new Person("Toni", 20);
        this.eder = new Person("Eder", 20);
        this.michael = new Person("Michael", 30);
        this.put(this.toni);
        this.put(this.eder);
        this.put(this.michael);
    }

    @Test
    void testFindByUUID() throws Exception {
        Assertions.assertThat((Collection)this.map.get(UUIDKey.UNIQUE_UUID).keySet()).containsExactlyInAnyOrder((Object[])new Value[]{this.toni.uuidKey.getSingleValue(), this.eder.uuidKey.getSingleValue(), this.michael.uuidKey.getSingleValue()});
    }

    @Test
    void testReAdd() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.put(this.toni));
    }

    @Test
    void testFindByName() throws Exception {
        MultiMap multiMap = this.map.get(KeyDefinition.newKeyDefinition().withId("name").build());
        Assertions.assertThat((Collection)multiMap.keySet()).extracting(x -> x.getComparable()).containsExactlyInAnyOrder((Object[])new Comparable[]{"Toni", "Eder", "Michael"});
    }

    @Test
    void testFindByAge() throws Exception {
        MultiMap age = this.map.get(KeyDefinition.newKeyDefinition().withId("age").build());
        Assertions.assertThat((Collection)age.keySet()).extracting(x -> x.getComparable()).containsExactly((Object[])new Comparable[]{Integer.valueOf(20), Integer.valueOf(30)});
        Assertions.assertThat((List)age.get((Comparable)new Value((Comparable)Integer.valueOf(20)))).contains((Object[])new Person[]{this.toni, this.eder});
    }

    @Test
    void testUpdateAge() throws Exception {
        MultiMapChangeHandler changeHandler = (MultiMapChangeHandler)Mockito.mock(MultiMapChangeHandler.class);
        this.map.get(this.AGE).addChangeListener(changeHandler);
        this.toni.setAge(10);
        MultiMap age = this.map.get(this.AGE);
        Assertions.assertThat((List)age.get((Comparable)new Value((Comparable)Integer.valueOf(20)))).doesNotContain((Object[])new Person[]{this.toni});
        Assertions.assertThat((List)age.get((Comparable)new Value((Comparable)Integer.valueOf(10)))).contains((Object[])new Person[]{this.toni});
    }

    @Test
    void testRetract() throws Exception {
        this.toni.uuidKey.retract();
        Assertions.assertThat((Collection)this.map.get(UUIDKey.UNIQUE_UUID).keySet()).containsExactlyInAnyOrder((Object[])new Value[]{this.eder.uuidKey.getSingleValue(), this.michael.uuidKey.getSingleValue()});
        MultiMap nameMap = this.map.get(KeyDefinition.newKeyDefinition().withId("name").build());
        Assertions.assertThat((Collection)nameMap.keySet()).extracting(x -> x.getComparable()).containsExactly((Object[])new Comparable[]{"Eder", "Michael"});
        MultiMap ageMap = this.map.get(KeyDefinition.newKeyDefinition().withId("age").build());
        Assertions.assertThat((Collection)ageMap.keySet()).extracting(x -> x.getComparable()).containsExactly((Object[])new Comparable[]{Integer.valueOf(20), Integer.valueOf(30)});
    }

    @Test
    void testRemoveWhenItemDoesNotExist() throws Exception {
        UUIDKey uuidKey = (UUIDKey)Mockito.mock(UUIDKey.class);
        Mockito.when((Object)uuidKey.getKeyDefinition()).thenReturn((Object)UUIDKey.UNIQUE_UUID);
        Mockito.when((Object)uuidKey.getSingleValue()).thenReturn((Object)new Value((Comparable)((Object)"DoesNotExist")));
        Assertions.assertThat((Object)((Person)this.map.remove(uuidKey))).isNull();
        Assertions.assertThat((int)this.map.get(UUIDKey.UNIQUE_UUID).size()).isEqualTo(3);
    }

    private void put(Person person) {
        this.map.put((HasKeys)person);
    }

    class Person
    implements HasKeys {
        final String name;
        private final UUIDKey uuidKey;
        private UpdatableKey ageKey;

        public Person(String name, int age) {
            this.uuidKey = KeyTreeMapTest.this.configuration.getUUID((HasKeys)this);
            this.name = name;
            this.ageKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey, new Key(KeyTreeMapTest.this.NAME, (Comparable)((Object)this.name)), this.ageKey};
        }

        public void setAge(int age) {
            UpdatableKey newKey;
            UpdatableKey oldKey = this.ageKey;
            this.ageKey = newKey = new UpdatableKey(KeyTreeMapTest.this.AGE, (Comparable)Integer.valueOf(age));
            oldKey.update(newKey, (Object)this);
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }
    }
}

