/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.RuleInspectorCache;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckFactory;
import org.drools.verifier.core.checks.base.CheckRunManager;
import org.drools.verifier.core.checks.base.CheckRunner;
import org.drools.verifier.core.checks.base.CheckStorage;
import org.drools.verifier.core.checks.base.JavaCheckRunner;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Rule;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CheckRunManagerTest {
    @Spy
    private CheckRunManager checkRunManager = new CheckRunManager((CheckRunner)new JavaCheckRunner());
    @Mock
    private RuleInspectorCache cache;
    private RuleInspector ruleInspector1;
    private RuleInspector ruleInspector2;
    private RuleInspector ruleInspector3;
    private ArrayList<RuleInspector> ruleInspectors;
    private CheckStorage checkStorage;
    private AnalyzerConfiguration configuration;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.checkStorage = new CheckStorage(new CheckFactory(this.configuration){

            public HashSet<Check> makeSingleChecks(RuleInspector ruleInspector) {
                HashSet<Check> result = new HashSet<Check>();
                result.add((Check)new MockSingleCheck(ruleInspector));
                return result;
            }
        });
        this.ruleInspectors = new ArrayList();
        this.ruleInspector1 = this.mockRowInspector(1);
        this.ruleInspectors.add(this.ruleInspector1);
        this.ruleInspector2 = this.mockRowInspector(2);
        this.ruleInspectors.add(this.ruleInspector2);
        this.ruleInspector3 = this.mockRowInspector(3);
        this.ruleInspectors.add(this.ruleInspector3);
        this.checkRunManager.addChecks(this.ruleInspector1.getChecks());
        this.checkRunManager.addChecks(this.ruleInspector2.getChecks());
        this.checkRunManager.addChecks(this.ruleInspector3.getChecks());
    }

    @Test
    void testChecksGetGenerated() throws Exception {
        Assertions.assertThat((Collection)this.ruleInspector1.getChecks()).hasSize(5);
        Assertions.assertThat((Collection)this.ruleInspector2.getChecks()).hasSize(5);
        Assertions.assertThat((Collection)this.ruleInspector3.getChecks()).hasSize(5);
    }

    @Test
    void testRemove() throws Exception {
        this.checkRunManager.remove(this.ruleInspector2);
        Assertions.assertThat((Collection)this.ruleInspector1.getChecks()).hasSize(3);
        Assertions.assertThat((Collection)this.ruleInspector2.getChecks()).isEmpty();
        Assertions.assertThat((Collection)this.ruleInspector3.getChecks()).hasSize(3);
    }

    @Test
    void testRunTests() throws Exception {
        for (RuleInspector ruleInspector : this.cache.all()) {
            Assertions.assertThat((Collection)ruleInspector.getChecks()).noneMatch(check -> check.hasIssues());
        }
        this.checkRunManager.run(null, null);
        for (RuleInspector ruleInspector : this.cache.all()) {
            Assertions.assertThat((Collection)ruleInspector.getChecks()).allMatch(check -> check.hasIssues());
        }
    }

    @Test
    void testOnlyTestChanges() throws Exception {
        this.checkRunManager.run(null, null);
        RuleInspector newRuleInspector = this.mockRowInspector(3);
        this.ruleInspectors.add(newRuleInspector);
        this.checkRunManager.addChecks(newRuleInspector.getChecks());
        Assertions.assertThat((Collection)newRuleInspector.getChecks()).noneMatch(check1 -> check1.hasIssues());
        this.checkRunManager.run(null, null);
        RuleInspector ruleInspector = newRuleInspector;
        Assertions.assertThat((Collection)ruleInspector.getChecks()).allMatch(check -> check.hasIssues());
        Assertions.assertThat((Collection)this.ruleInspector1.getChecks()).hasSize(7);
        Assertions.assertThat((Collection)newRuleInspector.getChecks()).hasSize(7);
    }

    private RuleInspector mockRowInspector(int rowNumber) {
        return new RuleInspector(new Rule(Integer.valueOf(rowNumber), this.configuration), this.checkStorage, this.cache, (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    private class MockSingleCheck
    extends SingleCheck {
        public MockSingleCheck(RuleInspector ruleInspector) {
            super(ruleInspector, CheckRunManagerTest.this.configuration, CheckType.REDUNDANT_ROWS);
        }

        public boolean check() {
            this.hasIssues = true;
            return true;
        }

        protected Severity getDefaultSeverity() {
            return Severity.NOTE;
        }

        protected Issue makeIssue(Severity severity, CheckType checkType) {
            return new Issue(severity, checkType, Collections.emptySet());
        }
    }
}

