/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.HashSet;
import java.util.List;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.api.reporting.ValueForActionIsSetTwiceIssue;
import org.drools.verifier.core.cache.inspectors.PatternInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.verifier.core.checks.DetectRedundantActionBase;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.maps.InspectorMultiMap;
import org.drools.verifier.core.maps.util.RedundancyResult;

public class DetectRedundantActionValueCheck
extends DetectRedundantActionBase {
    public DetectRedundantActionValueCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.VALUE_FOR_ACTION_IS_SET_TWICE);
    }

    @Override
    public boolean check() {
        this.result = this.ruleInspector.getPatternsInspector().stream().filter(p -> p.getPattern().getBoundName() != null).peek(p -> {
            this.patternInspector = p;
        }).map(PatternInspector::getActionsInspector).map(InspectorMultiMap::hasRedundancy).filter(RedundancyResult::isTrue).findFirst().orElse(null);
        this.hasIssues = this.result != null;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new ValueForActionIsSetTwiceIssue(severity, checkType, ((ActionInspector)this.result.get(0)).toHumanReadableString(), ((ActionInspector)this.result.get(1)).toHumanReadableString(), new HashSet<Integer>(List.of(Integer.valueOf(this.ruleInspector.getRowIndex() + 1))));
    }
}

