/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspectorUtils;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Field;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StringConditionInspectorConflictResolverOverlapTest {
    @Mock
    private Field field;

    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", new Values(new Comparable[]{"a"}), "==", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false, true}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), false, true}, {"matches", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"soundslike", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"b"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), true, false}, {"==", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"==", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {"==", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), true, false}, {"==", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"a", "b"}), true, false}, {"==", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"==", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "!=", new Values(new Comparable[]{"a"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{" "}), false, false}, {"!=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"!=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"!=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), true, false}, {">", new Values(new Comparable[]{"a"}), ">", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"c"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a", "b"}), false, false}, {">", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {">", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1", "A", "B", "a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {">=", new Values(new Comparable[]{"a"}), ">=", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{" "}), false, false}, {">=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"0", "1", "A", "B"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {">=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"A", "B", "a", "b"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {"<", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "<=", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"A", "B", "a", "b"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"A"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{""}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "matches", new Values(new Comparable[]{"a"}), false, false}, {"<=", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, false}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"b", "c", "d"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"a"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"in", new Values(new Comparable[]{"a", "b"}), "in", new Values(new Comparable[]{"c", "d"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "not in", new Values(new Comparable[]{"a", "b"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"c"}), true, false}, {"in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"c"}), true, false}, {"not in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"c"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "soundslike", new Values(new Comparable[]{"c"}), false, true}, {"not in", new Values(new Comparable[]{"a", "b"}), "matches", new Values(new Comparable[]{"a"}), true, false}, {"matches", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true}, {"matches", new Values(new Comparable[]{"a"}), "soundslike", new Values(new Comparable[]{"a"}), false, true});
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedConflictTest(String operator1, Values value1, String operator2, Values value2, boolean conflictExpected, boolean overlapExpected) {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, value1, operator1);
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, value2, operator2);
        boolean conflicts = a.conflicts((Object)b);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conflicts).as(this.getAssertDescription(a, b, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
        boolean conflicts1 = b.conflicts((Object)a);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conflicts1).as(this.getAssertDescription(b, a, conflictExpected, "conflict"), new Object[0])).isEqualTo(conflictExpected);
    }

    @MethodSource(value={"testData"})
    @ParameterizedTest
    void parametrizedOverlapTest(String operator1, Values value1, String operator2, Values value2, boolean conflictExpected, boolean overlapExpected) {
        StringConditionInspector a = ConditionInspectorUtils.getStringCondition(this.field, value1, operator1);
        StringConditionInspector b = ConditionInspectorUtils.getStringCondition(this.field, value2, operator2);
        boolean overlaps = a.overlaps((Object)b);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)overlaps).as(this.getAssertDescription(a, b, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
        boolean overlaps1 = b.overlaps((Object)a);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)overlaps1).as(this.getAssertDescription(b, a, overlapExpected, "overlap"), new Object[0])).isEqualTo(overlapExpected);
    }

    private String getAssertDescription(StringConditionInspector a, StringConditionInspector b, boolean conflictExpected, String condition) {
        return String.format("Expected condition '%s' %sto %s with condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", condition, b.toHumanReadableString());
    }
}

