/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ChangeHandledMultiMapPreExistingDataTest {
    private MultiMap<Value, String, List<String>> map;
    private MultiMapChangeHandler.ChangeSet<Value, String> changeSet;
    private int timesCalled = 0;

    @BeforeEach
    public void setUp() throws Exception {
        this.timesCalled = 0;
        this.map = MultiMapFactory.make((boolean)true);
        this.map.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"a");
        this.map.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"b");
        this.map.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"c");
        this.map.addChangeListener((MultiMapChangeHandler)new MultiMapChangeHandler<Value, String>(){

            public void onChange(MultiMapChangeHandler.ChangeSet<Value, String> changeSet) {
                ChangeHandledMultiMapPreExistingDataTest.this.changeSet = changeSet;
                ++ChangeHandledMultiMapPreExistingDataTest.this.timesCalled;
            }
        });
    }

    @Test
    void move() throws Exception {
        this.map.move((Set)new Values(new Comparable[]{new Value((Comparable)((Object)"ok"))}), (Set)new Values(new Comparable[]{new Value((Comparable)((Object)"hello"))}), (Object)"b");
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
        ((ListAssert)Assertions.assertThat((List)this.map.get((Comparable)new Value((Comparable)((Object)"hello")))).hasSize(2)).contains((Object[])new String[]{"a", "b"});
        ((ListAssert)Assertions.assertThat((List)this.map.get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(1)).contains((Object[])new String[]{"c"});
        Assertions.assertThat((List)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(1);
        Assertions.assertThat((List)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello")))).hasSize(1);
    }

    @Test
    void testRemove() throws Exception {
        this.map.remove((Comparable)new Value((Comparable)((Object)"ok")));
        Assertions.assertThat((List)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(2);
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }

    @Test
    void testRemoveValue() throws Exception {
        this.map.removeValue((Comparable)new Value((Comparable)((Object)"ok")), (Object)"b");
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(1)).contains((Object[])new String[]{"b"});
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }

    @Test
    void testClear() throws Exception {
        this.map.clear();
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"hello")))).hasSize(1)).contains((Object[])new String[]{"a"});
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getRemoved().get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(2)).contains((Object[])new String[]{"b", "c"});
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }

    @Test
    void testMerge() throws Exception {
        MultiMap other = MultiMapFactory.make();
        other.put((Comparable)new Value((Comparable)((Object)"hello")), (Object)"d");
        other.put((Comparable)new Value((Comparable)((Object)"ok")), (Object)"e");
        other.put((Comparable)new Value((Comparable)((Object)"newOne")), (Object)"f");
        MultiMap.merge(this.map, (MultiMap)other);
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"hello")))).hasSize(1)).contains((Object[])new String[]{"d"});
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"ok")))).hasSize(1)).contains((Object[])new String[]{"e"});
        ((ListAssert)Assertions.assertThat((List)this.changeSet.getAdded().get((Comparable)new Value((Comparable)((Object)"newOne")))).hasSize(1)).contains((Object[])new String[]{"f"});
        Assertions.assertThat((int)this.timesCalled).isEqualTo(1);
    }
}

