/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsOverlapping;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;
import org.drools.verifier.core.relations.RelationResolver;

public class InspectorList<InspectorType extends HasUUID>
extends ArrayList<InspectorType>
implements IsOverlapping,
IsSubsuming<InspectorList>,
IsRedundant<InspectorList>,
IsConflicting<InspectorList>,
HasKeys {
    private final UUIDKey uuidKey;
    private final RelationResolver relationResolver;

    public InspectorList(AnalyzerConfiguration configuration) {
        this(false, configuration);
    }

    public InspectorList(boolean record, AnalyzerConfiguration configuration) {
        this.relationResolver = new RelationResolver(this, record);
        this.uuidKey = configuration.getUUID(this);
    }

    @Override
    public boolean overlaps(Object other) {
        return false;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    @Override
    public boolean conflicts(InspectorList other) {
        return this.relationResolver.isConflicting(other);
    }

    @Override
    public boolean isRedundant(InspectorList other) {
        return this.relationResolver.isRedundant(other);
    }

    @Override
    public boolean subsumes(InspectorList other) {
        return this.relationResolver.subsumes(other);
    }

    @Override
    public boolean add(InspectorType inspector) {
        return super.add(inspector);
    }

    @Override
    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

