/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.matchers.UUIDMatchers;
import org.drools.verifier.core.index.model.ActionSuperType;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.query.Matchers;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.util.PortablePreconditions;

public abstract class Action
implements HasKeys {
    protected static final KeyDefinition VALUE = KeyDefinition.newKeyDefinition().withId("value").updatable().build();
    protected static final KeyDefinition SUPER_TYPE = KeyDefinition.newKeyDefinition().withId("superType").updatable().build();
    protected static final KeyDefinition COLUMN_UUID = KeyDefinition.newKeyDefinition().withId("columnUUID").build();
    protected final UUIDKey uuidKey;
    protected final Column column;
    private final ActionSuperType superType;
    private final Values<Comparable> values = new Values();
    protected UpdatableKey<Action> valueKey;

    public Action(Column column, ActionSuperType superType, Values values, AnalyzerConfiguration configuration) {
        this.column = PortablePreconditions.checkNotNull("column", column);
        this.superType = PortablePreconditions.checkNotNull("superType", superType);
        this.valueKey = new UpdatableKey(VALUE, values);
        this.uuidKey = configuration.getUUID(this);
        this.resetValues();
    }

    public static Matchers value() {
        return new Matchers(VALUE);
    }

    public static Matchers superType() {
        return new Matchers(SUPER_TYPE);
    }

    public static Matchers columnUUID() {
        return new Matchers(COLUMN_UUID);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, COLUMN_UUID, SUPER_TYPE, VALUE};
    }

    private void resetValues() {
        this.values.clear();
        for (Value o : this.valueKey.getValues()) {
            this.values.add(o.getComparable());
        }
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public Values<Comparable> getValues() {
        return this.values;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, new Key(SUPER_TYPE, (Comparable)((Object)this.superType)), new Key(COLUMN_UUID, this.column.getUuidKey()), this.valueKey};
    }

    public void setValue(Values values) {
        if (!this.valueKey.getValues().isThereChanges(values)) {
            return;
        }
        UpdatableKey<Action> oldKey = this.valueKey;
        UpdatableKey newKey = new UpdatableKey(VALUE, values);
        this.valueKey = newKey;
        oldKey.update(newKey, this);
        this.resetValues();
    }
}

