/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.assertj.core.api.Assertions;
import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.RelationResolver;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RelationResolverConflictsTest {
    private AnalyzerConfiguration configuration;
    private RelationResolver relationResolver;
    private InspectorList a;
    private InspectorList b;
    private Person isConflicting;
    private Person firstItemInA;

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration = new AnalyzerConfigurationMock();
        this.a = new InspectorList(this.configuration);
        this.b = new InspectorList(this.configuration);
        this.firstItemInA = (Person)Mockito.spy((Object)new Person(10));
        this.isConflicting = (Person)Mockito.spy((Object)new Person(15));
        this.a.add((HasUUID)this.firstItemInA);
        this.a.add((HasUUID)this.isConflicting);
        this.b.add((HasUUID)new Person(10));
        this.relationResolver = new RelationResolver(this.a, true);
    }

    @Test
    void empty() throws Exception {
        this.relationResolver = new RelationResolver(new InspectorList(this.configuration));
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(new InspectorList(this.configuration))).isFalse();
    }

    @Test
    void recheck() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isTrue();
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isTrue();
        ((Person)Mockito.verify((Object)this.firstItemInA, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
    }

    @Test
    void recheckWithUpdate() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isTrue();
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        this.isConflicting.setAge(10);
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isFalse();
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
    }

    @Test
    void recheckConflictingItemRemoved() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isTrue();
        Mockito.reset((Object[])new Person[]{this.firstItemInA});
        this.a.remove((Object)this.isConflicting);
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isFalse();
        ((Person)Mockito.verify((Object)this.firstItemInA)).conflicts(Mockito.any());
    }

    @Test
    void recheckOtherListBecomesEmpty() throws Exception {
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isTrue();
        Mockito.reset((Object[])new Person[]{this.firstItemInA, this.isConflicting});
        this.b.clear();
        Assertions.assertThat((boolean)this.relationResolver.isConflicting(this.b)).isFalse();
        ((Person)Mockito.verify((Object)this.firstItemInA, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
        ((Person)Mockito.verify((Object)this.isConflicting, (VerificationMode)Mockito.never())).conflicts(Mockito.any());
    }

    public class Person
    implements IsConflicting,
    HasKeys {
        int age;
        private UUIDKey uuidKey;

        public Person(int age) {
            this.uuidKey = RelationResolverConflictsTest.this.configuration.getUUID((HasKeys)this);
            this.age = age;
        }

        public UUIDKey getUuidKey() {
            return this.uuidKey;
        }

        public Key[] keys() {
            return new Key[]{this.uuidKey};
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean conflicts(Object other) {
            if (other instanceof Person) {
                return this.age != ((Person)other).age;
            }
            return false;
        }
    }
}

