/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.drools.verifier.core.AnalyzerConfigurationMock;
import org.drools.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldCondition;
import org.mockito.Mockito;

public class ConditionInspectorUtils {
    public static String getAssertDescription(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), conflictExpected ? "" : "not ", b.toHumanReadableString());
    }

    public static String getAssertDescriptionForRedundant(ComparableConditionInspector a, ComparableConditionInspector b, boolean conflictExpected) {
        return String.format("Expected conditions '%s' and '%s' %sto be redundant:", a.toHumanReadableString(), b.toHumanReadableString(), conflictExpected ? "" : "not ");
    }

    public static StringConditionInspector getStringCondition(Field field, Values values, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new StringConditionInspector(ConditionInspectorUtils.fieldCondition(field, values, operator), (AnalyzerConfiguration)configurationMock);
    }

    public static NumericIntegerConditionInspector getNumericCondition(Field field, int value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new NumericIntegerConditionInspector(ConditionInspectorUtils.fieldCondition(field, Integer.valueOf(value), operator), (AnalyzerConfiguration)configurationMock);
    }

    public static ComparableConditionInspector getComparableCondition(Field field, Comparable value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(ConditionInspectorUtils.fieldCondition(field, value, operator), (AnalyzerConfiguration)configurationMock);
    }

    public static BooleanConditionInspector getBooleanCondition(Field field, boolean value, String operator) {
        return new BooleanConditionInspector(ConditionInspectorUtils.fieldCondition(field, Boolean.valueOf(value), operator), (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }

    public static <T> FieldCondition fieldCondition(Field field, Comparable<T> value, String operator) {
        return new FieldCondition(field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{value}), (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }

    public static <T> FieldCondition fieldCondition(Field field, Values value, String operator) {
        return new FieldCondition(field, (Column)Mockito.mock(Column.class), operator, value, (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }
}

